// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Inspect the body of the web request as JSON. The body immediately follows the request headers.
 *
 * This is used to indicate the web request component to inspect, in the FieldToMatch specification.
 *
 * Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. WAF inspects only the parts of the JSON that result from the matches that you indicate.
 *
 * Example JSON: `"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }`
 */
public class JsonBody private constructor(builder: Builder) {
    /**
     * What WAF should do if it fails to completely parse the JSON body. The options are the following:
     * + `EVALUATE_AS_STRING` - Inspect the body as plain text. WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     *
     * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure that it encounters.
     *
     * WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.
     *
     * WAF parses the JSON in the following examples as two valid key, value pairs:
     * + Missing comma: `{"key1":"value1""key2":"value2"}`
     * + Missing colon: `{"key1":"value1","key2""value2"}`
     * + Extra colons: `{"key1"::"value1","key2""value2"}`
     */
    public val invalidFallbackBehavior: aws.sdk.kotlin.services.wafv2.model.BodyParsingFallbackBehavior? = builder.invalidFallbackBehavior
    /**
     * The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria.
     */
    public val matchPattern: aws.sdk.kotlin.services.wafv2.model.JsonMatchPattern? = builder.matchPattern
    /**
     * The parts of the JSON to match against using the `MatchPattern`. If you specify `All`, WAF matches against keys and values.
     */
    public val matchScope: aws.sdk.kotlin.services.wafv2.model.JsonMatchScope = requireNotNull(builder.matchScope) { "A non-null value must be provided for matchScope" }
    /**
     * What WAF should do if the body is larger than WAF can inspect. WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to WAF for inspection.
     *
     * The default limit is 8 KB (8,192 bytes) for regional resources and 16 KB (16,384 bytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL `AssociationConfig`, for additional processing fees.
     *
     * The options for oversize handling are the following:
     * + `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     *
     * You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
     *
     * Default: `CONTINUE`
     */
    public val oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = builder.oversizeHandling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.JsonBody = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JsonBody(")
        append("invalidFallbackBehavior=$invalidFallbackBehavior,")
        append("matchPattern=$matchPattern,")
        append("matchScope=$matchScope,")
        append("oversizeHandling=$oversizeHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = invalidFallbackBehavior?.hashCode() ?: 0
        result = 31 * result + (matchPattern?.hashCode() ?: 0)
        result = 31 * result + (matchScope.hashCode())
        result = 31 * result + (oversizeHandling?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JsonBody

        if (invalidFallbackBehavior != other.invalidFallbackBehavior) return false
        if (matchPattern != other.matchPattern) return false
        if (matchScope != other.matchScope) return false
        if (oversizeHandling != other.oversizeHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.JsonBody = Builder(this).apply(block).build()

    public class Builder {
        /**
         * What WAF should do if it fails to completely parse the JSON body. The options are the following:
         * + `EVALUATE_AS_STRING` - Inspect the body as plain text. WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         *
         * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure that it encounters.
         *
         * WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.
         *
         * WAF parses the JSON in the following examples as two valid key, value pairs:
         * + Missing comma: `{"key1":"value1""key2":"value2"}`
         * + Missing colon: `{"key1":"value1","key2""value2"}`
         * + Extra colons: `{"key1"::"value1","key2""value2"}`
         */
        public var invalidFallbackBehavior: aws.sdk.kotlin.services.wafv2.model.BodyParsingFallbackBehavior? = null
        /**
         * The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria.
         */
        public var matchPattern: aws.sdk.kotlin.services.wafv2.model.JsonMatchPattern? = null
        /**
         * The parts of the JSON to match against using the `MatchPattern`. If you specify `All`, WAF matches against keys and values.
         */
        public var matchScope: aws.sdk.kotlin.services.wafv2.model.JsonMatchScope? = null
        /**
         * What WAF should do if the body is larger than WAF can inspect. WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to WAF for inspection.
         *
         * The default limit is 8 KB (8,192 bytes) for regional resources and 16 KB (16,384 bytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL `AssociationConfig`, for additional processing fees.
         *
         * The options for oversize handling are the following:
         * + `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         *
         * You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
         *
         * Default: `CONTINUE`
         */
        public var oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.JsonBody) : this() {
            this.invalidFallbackBehavior = x.invalidFallbackBehavior
            this.matchPattern = x.matchPattern
            this.matchScope = x.matchScope
            this.oversizeHandling = x.oversizeHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.JsonBody = JsonBody(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.JsonMatchPattern] inside the given [block]
         */
        public fun matchPattern(block: aws.sdk.kotlin.services.wafv2.model.JsonMatchPattern.Builder.() -> kotlin.Unit) {
            this.matchPattern = aws.sdk.kotlin.services.wafv2.model.JsonMatchPattern.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (matchScope == null) matchScope = JsonMatchScope.SdkUnknown("no value provided")
            return this
        }
    }
}
