// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
 *
 * You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY`.
 *
 * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *WAF Developer Guide*.
 *
 * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
 */
public class Ja3Fingerprint private constructor(builder: Builder) {
    /**
     * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
     *
     * You can specify the following fallback behaviors:
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     */
    public val fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior = requireNotNull(builder.fallbackBehavior) { "A non-null value must be provided for fallbackBehavior" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ja3Fingerprint(")
        append("fallbackBehavior=$fallbackBehavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fallbackBehavior.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ja3Fingerprint

        if (fallbackBehavior != other.fallbackBehavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
         *
         * You can specify the following fallback behaviors:
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         */
        public var fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint) : this() {
            this.fallbackBehavior = x.fallbackBehavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint = Ja3Fingerprint(this)

        internal fun correctErrors(): Builder {
            if (fallbackBehavior == null) fallbackBehavior = FallbackBehavior.SdkUnknown("no value provided")
            return this
        }
    }
}
