// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Inspect a string containing the list of the request's header names, ordered as they appear in the web request that WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its inspection. WAF separates the header names in the string using colons and no added spaces, for example `host:user-agent:accept:authorization:referer`.
 */
public class HeaderOrder private constructor(builder: Builder) {
    /**
     * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
     *
     * The options for oversize handling are the following:
     * + `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     */
    public val oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling = requireNotNull(builder.oversizeHandling) { "A non-null value must be provided for oversizeHandling" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.HeaderOrder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HeaderOrder(")
        append("oversizeHandling=$oversizeHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = oversizeHandling.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HeaderOrder

        if (oversizeHandling != other.oversizeHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.HeaderOrder = Builder(this).apply(block).build()

    public class Builder {
        /**
         * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
         *
         * The options for oversize handling are the following:
         * + `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         */
        public var oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.HeaderOrder) : this() {
            this.oversizeHandling = x.oversizeHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.HeaderOrder = HeaderOrder(this)

        internal fun correctErrors(): Builder {
            if (oversizeHandling == null) oversizeHandling = OversizeHandling.SdkUnknown("no value provided")
            return this
        }
    }
}
