// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The part of the web request that you want WAF to inspect. Include the single `FieldToMatch` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in `FieldToMatch` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.
 *
 * Example JSON for a `QueryString` field to match:
 *
 * ` "FieldToMatch": { "QueryString": {} }`
 *
 * Example JSON for a `Method` field to match specification:
 *
 * ` "FieldToMatch": { "Method": { "Name": "DELETE" } }`
 */
public class FieldToMatch private constructor(builder: Builder) {
    /**
     * Inspect all query arguments.
     */
    public val allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = builder.allQueryArguments
    /**
     * Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
     *
     * A limited amount of the request body is forwarded to WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 bytes) and for CloudFront distributions, the limit is 16 KB (16,384 bytes). For CloudFront distributions, you can increase the limit in the web ACL's `AssociationConfig`, for additional processing fees.
     *
     * For information about how to handle oversized request bodies, see the `Body` object configuration.
     */
    public val body: aws.sdk.kotlin.services.wafv2.model.Body? = builder.body
    /**
     * Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that WAF inspects.
     *
     * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
     */
    public val cookies: aws.sdk.kotlin.services.wafv2.model.Cookies? = builder.cookies
    /**
     * Inspect a string containing the list of the request's header names, ordered as they appear in the web request that WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its inspection. WAF separates the header names in the string using colons and no added spaces, for example `host:user-agent:accept:authorization:referer`.
     */
    public val headerOrder: aws.sdk.kotlin.services.wafv2.model.HeaderOrder? = builder.headerOrder
    /**
     * Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that WAF inspects.
     *
     * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
     */
    public val headers: aws.sdk.kotlin.services.wafv2.model.Headers? = builder.headers
    /**
     * Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
     *
     * You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY`.
     *
     * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *WAF Developer Guide*.
     *
     * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
     */
    public val ja3Fingerprint: aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint? = builder.ja3Fingerprint
    /**
     * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
     *
     * A limited amount of the request body is forwarded to WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 bytes) and for CloudFront distributions, the limit is 16 KB (16,384 bytes). For CloudFront distributions, you can increase the limit in the web ACL's `AssociationConfig`, for additional processing fees.
     *
     * For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
     */
    public val jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = builder.jsonBody
    /**
     * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    public val method: aws.sdk.kotlin.services.wafv2.model.Method? = builder.method
    /**
     * Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    public val queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = builder.queryString
    /**
     * Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer`. This setting isn't case sensitive.
     *
     * Example JSON: `"SingleHeader": { "Name": "haystack" }`
     *
     * Alternately, you can filter and inspect all headers with the `Headers``FieldToMatch` setting.
     */
    public val singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = builder.singleHeader
    /**
     * Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion*. The name can be up to 30 characters long and isn't case sensitive.
     *
     * Example JSON: `"SingleQueryArgument": { "Name": "myArgument" }`
     */
    public val singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = builder.singleQueryArgument
    /**
     * Inspect the request URI path. This is the part of the web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    public val uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = builder.uriPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldToMatch(")
        append("allQueryArguments=$allQueryArguments,")
        append("body=$body,")
        append("cookies=$cookies,")
        append("headerOrder=$headerOrder,")
        append("headers=$headers,")
        append("ja3Fingerprint=$ja3Fingerprint,")
        append("jsonBody=$jsonBody,")
        append("method=$method,")
        append("queryString=$queryString,")
        append("singleHeader=$singleHeader,")
        append("singleQueryArgument=$singleQueryArgument,")
        append("uriPath=$uriPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allQueryArguments?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (cookies?.hashCode() ?: 0)
        result = 31 * result + (headerOrder?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (ja3Fingerprint?.hashCode() ?: 0)
        result = 31 * result + (jsonBody?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (singleHeader?.hashCode() ?: 0)
        result = 31 * result + (singleQueryArgument?.hashCode() ?: 0)
        result = 31 * result + (uriPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FieldToMatch

        if (allQueryArguments != other.allQueryArguments) return false
        if (body != other.body) return false
        if (cookies != other.cookies) return false
        if (headerOrder != other.headerOrder) return false
        if (headers != other.headers) return false
        if (ja3Fingerprint != other.ja3Fingerprint) return false
        if (jsonBody != other.jsonBody) return false
        if (method != other.method) return false
        if (queryString != other.queryString) return false
        if (singleHeader != other.singleHeader) return false
        if (singleQueryArgument != other.singleQueryArgument) return false
        if (uriPath != other.uriPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Inspect all query arguments.
         */
        public var allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = null
        /**
         * Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         *
         * A limited amount of the request body is forwarded to WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 bytes) and for CloudFront distributions, the limit is 16 KB (16,384 bytes). For CloudFront distributions, you can increase the limit in the web ACL's `AssociationConfig`, for additional processing fees.
         *
         * For information about how to handle oversized request bodies, see the `Body` object configuration.
         */
        public var body: aws.sdk.kotlin.services.wafv2.model.Body? = null
        /**
         * Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that WAF inspects.
         *
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
         */
        public var cookies: aws.sdk.kotlin.services.wafv2.model.Cookies? = null
        /**
         * Inspect a string containing the list of the request's header names, ordered as they appear in the web request that WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its inspection. WAF separates the header names in the string using colons and no added spaces, for example `host:user-agent:accept:authorization:referer`.
         */
        public var headerOrder: aws.sdk.kotlin.services.wafv2.model.HeaderOrder? = null
        /**
         * Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that WAF inspects.
         *
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
         */
        public var headers: aws.sdk.kotlin.services.wafv2.model.Headers? = null
        /**
         * Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
         *
         * You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY`.
         *
         * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *WAF Developer Guide*.
         *
         * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
         */
        public var ja3Fingerprint: aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint? = null
        /**
         * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         *
         * A limited amount of the request body is forwarded to WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 bytes) and for CloudFront distributions, the limit is 16 KB (16,384 bytes). For CloudFront distributions, you can increase the limit in the web ACL's `AssociationConfig`, for additional processing fees.
         *
         * For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
         */
        public var jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = null
        /**
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
         */
        public var method: aws.sdk.kotlin.services.wafv2.model.Method? = null
        /**
         * Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
         */
        public var queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = null
        /**
         * Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer`. This setting isn't case sensitive.
         *
         * Example JSON: `"SingleHeader": { "Name": "haystack" }`
         *
         * Alternately, you can filter and inspect all headers with the `Headers``FieldToMatch` setting.
         */
        public var singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = null
        /**
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion*. The name can be up to 30 characters long and isn't case sensitive.
         *
         * Example JSON: `"SingleQueryArgument": { "Name": "myArgument" }`
         */
        public var singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = null
        /**
         * Inspect the request URI path. This is the part of the web request that identifies a resource, for example, `/images/daily-ad.jpg`.
         */
        public var uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.FieldToMatch) : this() {
            this.allQueryArguments = x.allQueryArguments
            this.body = x.body
            this.cookies = x.cookies
            this.headerOrder = x.headerOrder
            this.headers = x.headers
            this.ja3Fingerprint = x.ja3Fingerprint
            this.jsonBody = x.jsonBody
            this.method = x.method
            this.queryString = x.queryString
            this.singleHeader = x.singleHeader
            this.singleQueryArgument = x.singleQueryArgument
            this.uriPath = x.uriPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = FieldToMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AllQueryArguments] inside the given [block]
         */
        public fun allQueryArguments(block: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.Builder.() -> kotlin.Unit) {
            this.allQueryArguments = aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Body] inside the given [block]
         */
        public fun body(block: aws.sdk.kotlin.services.wafv2.model.Body.Builder.() -> kotlin.Unit) {
            this.body = aws.sdk.kotlin.services.wafv2.model.Body.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Cookies] inside the given [block]
         */
        public fun cookies(block: aws.sdk.kotlin.services.wafv2.model.Cookies.Builder.() -> kotlin.Unit) {
            this.cookies = aws.sdk.kotlin.services.wafv2.model.Cookies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.HeaderOrder] inside the given [block]
         */
        public fun headerOrder(block: aws.sdk.kotlin.services.wafv2.model.HeaderOrder.Builder.() -> kotlin.Unit) {
            this.headerOrder = aws.sdk.kotlin.services.wafv2.model.HeaderOrder.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Headers] inside the given [block]
         */
        public fun headers(block: aws.sdk.kotlin.services.wafv2.model.Headers.Builder.() -> kotlin.Unit) {
            this.headers = aws.sdk.kotlin.services.wafv2.model.Headers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint] inside the given [block]
         */
        public fun ja3Fingerprint(block: aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint.Builder.() -> kotlin.Unit) {
            this.ja3Fingerprint = aws.sdk.kotlin.services.wafv2.model.Ja3Fingerprint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.JsonBody] inside the given [block]
         */
        public fun jsonBody(block: aws.sdk.kotlin.services.wafv2.model.JsonBody.Builder.() -> kotlin.Unit) {
            this.jsonBody = aws.sdk.kotlin.services.wafv2.model.JsonBody.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Method] inside the given [block]
         */
        public fun method(block: aws.sdk.kotlin.services.wafv2.model.Method.Builder.() -> kotlin.Unit) {
            this.method = aws.sdk.kotlin.services.wafv2.model.Method.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.QueryString] inside the given [block]
         */
        public fun queryString(block: aws.sdk.kotlin.services.wafv2.model.QueryString.Builder.() -> kotlin.Unit) {
            this.queryString = aws.sdk.kotlin.services.wafv2.model.QueryString.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleHeader] inside the given [block]
         */
        public fun singleHeader(block: aws.sdk.kotlin.services.wafv2.model.SingleHeader.Builder.() -> kotlin.Unit) {
            this.singleHeader = aws.sdk.kotlin.services.wafv2.model.SingleHeader.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument] inside the given [block]
         */
        public fun singleQueryArgument(block: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.Builder.() -> kotlin.Unit) {
            this.singleQueryArgument = aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UriPath] inside the given [block]
         */
        public fun uriPath(block: aws.sdk.kotlin.services.wafv2.model.UriPath.Builder.() -> kotlin.Unit) {
            this.uriPath = aws.sdk.kotlin.services.wafv2.model.UriPath.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
