// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is called a string match statement.
 */
public class ByteMatchStatement private constructor(builder: Builder) {
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The area within the portion of the web request that you want WAF to search for `SearchString`. Valid values include the following:
     *
     * **CONTAINS**
     *
     * The specified part of the web request must include the value of `SearchString`, but the location doesn't matter.
     *
     * **CONTAINS_WORD**
     *
     * The specified part of the web request must include the value of `SearchString`, and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
     * + `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot`.
     * + `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;`.
     *
     * **EXACTLY**
     *
     * The value of the specified part of the web request must exactly match the value of `SearchString`.
     *
     * **STARTS_WITH**
     *
     * The value of `SearchString` must appear at the beginning of the specified part of the web request.
     *
     * **ENDS_WITH**
     *
     * The value of `SearchString` must appear at the end of the specified part of the web request.
     */
    public val positionalConstraint: aws.sdk.kotlin.services.wafv2.model.PositionalConstraint = requireNotNull(builder.positionalConstraint) { "A non-null value must be provided for positionalConstraint" }
    /**
     * A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in FieldToMatch. The maximum length of the value is 200 bytes.
     *
     * Valid values depend on the component that you specify for inspection in `FieldToMatch`:
     * + `Method`: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request.
     * + `UriPath`: The value that you want WAF to search for in the URI path, for example, `/images/daily-ad.jpg`.
     * + `JA3Fingerprint`: Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY`. You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *WAF Developer Guide*.
     * + `HeaderOrder`: The comma-separated list of header names to match for. WAF creates a string that contains the ordered list of header names, from the headers in the web request, and then matches against that string.
     *
     * If `SearchString` includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
     *
     * **If you're using the WAF API**
     *
     * Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 200 bytes.
     *
     * For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent`. If you want to search the `User-Agent` header for the value `BadBot`, you base64-encode `BadBot` using MIME base64-encoding and include the resulting value, `QmFkQm90`, in the value of `SearchString`.
     *
     * **If you're using the CLI or one of the Amazon Web Services SDKs**
     *
     * The value that you want WAF to search for. The SDK automatically base64 encodes the value.
     */
    public val searchString: kotlin.ByteArray = requireNotNull(builder.searchString) { "A non-null value must be provided for searchString" }
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
     */
    public val textTransformations: List<TextTransformation> = requireNotNull(builder.textTransformations) { "A non-null value must be provided for textTransformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByteMatchStatement(")
        append("fieldToMatch=$fieldToMatch,")
        append("positionalConstraint=$positionalConstraint,")
        append("searchString=$searchString,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (positionalConstraint.hashCode())
        result = 31 * result + (searchString.contentHashCode())
        result = 31 * result + (textTransformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByteMatchStatement

        if (fieldToMatch != other.fieldToMatch) return false
        if (positionalConstraint != other.positionalConstraint) return false
        if (searchString != null) {
            if (other.searchString == null) return false
            if (!searchString.contentEquals(other.searchString)) return false
        } else if (other.searchString != null) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The area within the portion of the web request that you want WAF to search for `SearchString`. Valid values include the following:
         *
         * **CONTAINS**
         *
         * The specified part of the web request must include the value of `SearchString`, but the location doesn't matter.
         *
         * **CONTAINS_WORD**
         *
         * The specified part of the web request must include the value of `SearchString`, and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
         * + `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot`.
         * + `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;`.
         *
         * **EXACTLY**
         *
         * The value of the specified part of the web request must exactly match the value of `SearchString`.
         *
         * **STARTS_WITH**
         *
         * The value of `SearchString` must appear at the beginning of the specified part of the web request.
         *
         * **ENDS_WITH**
         *
         * The value of `SearchString` must appear at the end of the specified part of the web request.
         */
        public var positionalConstraint: aws.sdk.kotlin.services.wafv2.model.PositionalConstraint? = null
        /**
         * A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in FieldToMatch. The maximum length of the value is 200 bytes.
         *
         * Valid values depend on the component that you specify for inspection in `FieldToMatch`:
         * + `Method`: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request.
         * + `UriPath`: The value that you want WAF to search for in the URI path, for example, `/images/daily-ad.jpg`.
         * + `JA3Fingerprint`: Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY`. You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *WAF Developer Guide*.
         * + `HeaderOrder`: The comma-separated list of header names to match for. WAF creates a string that contains the ordered list of header names, from the headers in the web request, and then matches against that string.
         *
         * If `SearchString` includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
         *
         * **If you're using the WAF API**
         *
         * Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 200 bytes.
         *
         * For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent`. If you want to search the `User-Agent` header for the value `BadBot`, you base64-encode `BadBot` using MIME base64-encoding and include the resulting value, `QmFkQm90`, in the value of `SearchString`.
         *
         * **If you're using the CLI or one of the Amazon Web Services SDKs**
         *
         * The value that you want WAF to search for. The SDK automatically base64 encodes the value.
         */
        public var searchString: kotlin.ByteArray? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.positionalConstraint = x.positionalConstraint
            this.searchString = x.searchString
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = ByteMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (positionalConstraint == null) positionalConstraint = PositionalConstraint.SdkUnknown("no value provided")
            if (searchString == null) searchString = ByteArray(0)
            if (textTransformations == null) textTransformations = emptyList()
            return this
        }
    }
}
