// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



public class AssociateWebAclRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the web ACL.
     *
     * The ARN must be in one of the following formats:
     * + For an Application Load Balancer: `arn:<i>partition</i>:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> `
     * + For an Amazon API Gateway REST API: `arn:<i>partition</i>:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> `
     * + For an AppSync GraphQL API: `arn:<i>partition</i>:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> `
     * + For an Amazon Cognito user pool: `arn:<i>partition</i>:cognito-idp:<i>region</i>:<i>account-id</i>:userpool/<i>user-pool-id</i> `
     * + For an App Runner service: `arn:<i>partition</i>:apprunner:<i>region</i>:<i>account-id</i>:service/<i>apprunner-service-name</i>/<i>apprunner-service-id</i> `
     * + For an Amazon Web Services Verified Access instance: `arn:<i>partition</i>:ec2:<i>region</i>:<i>account-id</i>:verified-access-instance/<i>instance-id</i> `
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     */
    public val webAclArn: kotlin.String? = builder.webAclArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AssociateWebAclRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateWebAclRequest(")
        append("resourceArn=$resourceArn,")
        append("webAclArn=$webAclArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateWebAclRequest

        if (resourceArn != other.resourceArn) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AssociateWebAclRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource to associate with the web ACL.
         *
         * The ARN must be in one of the following formats:
         * + For an Application Load Balancer: `arn:<i>partition</i>:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> `
         * + For an Amazon API Gateway REST API: `arn:<i>partition</i>:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> `
         * + For an AppSync GraphQL API: `arn:<i>partition</i>:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> `
         * + For an Amazon Cognito user pool: `arn:<i>partition</i>:cognito-idp:<i>region</i>:<i>account-id</i>:userpool/<i>user-pool-id</i> `
         * + For an App Runner service: `arn:<i>partition</i>:apprunner:<i>region</i>:<i>account-id</i>:service/<i>apprunner-service-name</i>/<i>apprunner-service-id</i> `
         * + For an Amazon Web Services Verified Access instance: `arn:<i>partition</i>:ec2:<i>region</i>:<i>account-id</i>:verified-access-instance/<i>instance-id</i> `
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
         */
        public var webAclArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AssociateWebAclRequest) : this() {
            this.resourceArn = x.resourceArn
            this.webAclArn = x.webAclArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AssociateWebAclRequest = AssociateWebAclRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
