// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



public class UpdateWebAclRequest private constructor(builder: Builder) {
    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     *
     * Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to WAF for inspection. The default is 16 KB (16,384 bytes).
     *
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
     */
    public val associationConfig: aws.sdk.kotlin.services.wafv2.model.AssociationConfig? = builder.associationConfig
    /**
     * Specifies how WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings. If you don't specify this, WAF uses its default settings for `CaptchaConfig`.
     */
    public val captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = builder.captchaConfig
    /**
     * Specifies how WAF should handle challenge evaluations for rules that don't have their own `ChallengeConfig` settings. If you don't specify this, WAF uses its default settings for `ChallengeConfig`.
     */
    public val challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = builder.challengeConfig
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
     */
    public val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * The action to perform if none of the `Rules` contained in the `WebACL` match.
     */
    public val defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = builder.defaultAction
    /**
     * A description of the web ACL that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
     */
    public val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    public val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     *
     * Example JSON: `"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }`
     *
     * Public suffixes aren't allowed. For example, you can't use `usa.gov` or `co.uk` as token domains.
     */
    public val tokenDomains: List<String>? = builder.tokenDomains
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWebAclRequest(")
        append("associationConfig=$associationConfig,")
        append("captchaConfig=$captchaConfig,")
        append("challengeConfig=$challengeConfig,")
        append("customResponseBodies=$customResponseBodies,")
        append("defaultAction=$defaultAction,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name,")
        append("rules=$rules,")
        append("scope=$scope,")
        append("tokenDomains=$tokenDomains,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationConfig?.hashCode() ?: 0
        result = 31 * result + (captchaConfig?.hashCode() ?: 0)
        result = 31 * result + (challengeConfig?.hashCode() ?: 0)
        result = 31 * result + (customResponseBodies?.hashCode() ?: 0)
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (tokenDomains?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWebAclRequest

        if (associationConfig != other.associationConfig) return false
        if (captchaConfig != other.captchaConfig) return false
        if (challengeConfig != other.challengeConfig) return false
        if (customResponseBodies != other.customResponseBodies) return false
        if (defaultAction != other.defaultAction) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (scope != other.scope) return false
        if (tokenDomains != other.tokenDomains) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies custom configurations for the associations between the web ACL and protected resources.
         *
         * Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to WAF for inspection. The default is 16 KB (16,384 bytes).
         *
         * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
         */
        public var associationConfig: aws.sdk.kotlin.services.wafv2.model.AssociationConfig? = null
        /**
         * Specifies how WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings. If you don't specify this, WAF uses its default settings for `CaptchaConfig`.
         */
        public var captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = null
        /**
         * Specifies how WAF should handle challenge evaluations for rules that don't have their own `ChallengeConfig` settings. If you don't specify this, WAF uses its default settings for `ChallengeConfig`.
         */
        public var challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = null
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *WAF Developer Guide*.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *WAF Developer Guide*.
         */
        public var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * The action to perform if none of the `Rules` contained in the `WebACL` match.
         */
        public var defaultAction: aws.sdk.kotlin.services.wafv2.model.DefaultAction? = null
        /**
         * A description of the web ACL that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
         */
        public var lockToken: kotlin.String? = null
        /**
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<Rule>? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        public var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
         *
         * Example JSON: `"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }`
         *
         * Public suffixes aren't allowed. For example, you can't use `usa.gov` or `co.uk` as token domains.
         */
        public var tokenDomains: List<String>? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest) : this() {
            this.associationConfig = x.associationConfig
            this.captchaConfig = x.captchaConfig
            this.challengeConfig = x.challengeConfig
            this.customResponseBodies = x.customResponseBodies
            this.defaultAction = x.defaultAction
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
            this.rules = x.rules
            this.scope = x.scope
            this.tokenDomains = x.tokenDomains
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest = UpdateWebAclRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AssociationConfig] inside the given [block]
         */
        public fun associationConfig(block: aws.sdk.kotlin.services.wafv2.model.AssociationConfig.Builder.() -> kotlin.Unit) {
            this.associationConfig = aws.sdk.kotlin.services.wafv2.model.AssociationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaConfig] inside the given [block]
         */
        public fun captchaConfig(block: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.Builder.() -> kotlin.Unit) {
            this.captchaConfig = aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ChallengeConfig] inside the given [block]
         */
        public fun challengeConfig(block: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.Builder.() -> kotlin.Unit) {
            this.challengeConfig = aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.DefaultAction] inside the given [block]
         */
        public fun defaultAction(block: aws.sdk.kotlin.services.wafv2.model.DefaultAction.Builder.() -> kotlin.Unit) {
            this.defaultAction = aws.sdk.kotlin.services.wafv2.model.DefaultAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
