// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 */
public class TextTransformation private constructor(builder: Builder) {
    /**
     * Sets the relative processing order for multiple transformations. WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *WAF Developer Guide*.
     */
    public val type: aws.sdk.kotlin.services.wafv2.model.TextTransformationType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.TextTransformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TextTransformation(")
        append("priority=$priority,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TextTransformation

        if (priority != other.priority) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.TextTransformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets the relative processing order for multiple transformations. WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
         */
        public var priority: kotlin.Int = 0
        /**
         * For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *WAF Developer Guide*.
         */
        public var type: aws.sdk.kotlin.services.wafv2.model.TextTransformationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.TextTransformation) : this() {
            this.priority = x.priority
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.TextTransformation = TextTransformation(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = TextTransformationType.SdkUnknown("no value provided")
            return this
        }
    }
}
