// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The processing guidance for a Rule, used by WAF to determine whether a web request matches the rule.
 *
 * For example specifications, see the examples section of CreateWebACL.
 */
public class Statement private constructor(builder: Builder) {
    /**
     * A logical rule statement used to combine other rule statements with AND logic. You provide more than one Statement within the `AndStatement`.
     */
    public val andStatement: aws.sdk.kotlin.services.wafv2.model.AndStatement? = builder.andStatement
    /**
     * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is called a string match statement.
     */
    public val byteMatchStatement: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement? = builder.byteMatchStatement
    /**
     * A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.
     * + To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
     * + Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.
     *
     * WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig`.
     *
     * If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>`.
     *
     * If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>`.
     *
     * For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    public val geoMatchStatement: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement? = builder.geoMatchStatement
    /**
     * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an IPSet that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see CreateIPSet.
     *
     * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
     */
    public val ipSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement? = builder.ipSetReferenceStatement
    /**
     * A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
     *
     * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement.
     */
    public val labelMatchStatement: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement? = builder.labelMatchStatement
    /**
     * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
     *
     * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a managed rule group inside another rule group. You can only reference a managed rule group as a top-level statement within a rule that you define in a web ACL.
     *
     * You are charged additional fees when you use the WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet`, the WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet`, or the WAF Fraud Control account creation fraud prevention (ACFP) managed rule group `AWSManagedRulesACFPRuleSet`. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
     */
    public val managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = builder.managedRuleGroupStatement
    /**
     * A logical rule statement used to negate the results of another rule statement. You provide one Statement within the `NotStatement`.
     */
    public val notStatement: aws.sdk.kotlin.services.wafv2.model.NotStatement? = builder.notStatement
    /**
     * A logical rule statement used to combine other rule statements with OR logic. You provide more than one Statement within the `OrStatement`.
     */
    public val orStatement: aws.sdk.kotlin.services.wafv2.model.OrStatement? = builder.orStatement
    /**
     * A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
     *
     * You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.
     *
     * Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.
     *
     * For example, assume the rule evaluates web requests with the following IP address and HTTP method values:
     * + IP address 10.1.1.1, HTTP method POST
     * + IP address 10.1.1.1, HTTP method GET
     * + IP address 127.0.0.0, HTTP method POST
     * + IP address 10.1.1.1, HTTP method GET
     *
     * The rule would create different aggregation instances according to your aggregation criteria, for example:
     * + If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
     *    + IP address 10.1.1.1: count 3
     *    + IP address 127.0.0.0: count 1
     * + If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
     *    + HTTP method POST: count 2
     *    + HTTP method GET: count 2
     * + If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
     *    + IP address 10.1.1.1, HTTP method POST: count 1
     *    + IP address 10.1.1.1, HTTP method GET: count 2
     *    + IP address 127.0.0.0, HTTP method POST: count 1
     *
     * For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which WAF counts and rate-limits individually.
     *
     * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.
     *
     * You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement`. You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
     *
     * For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *WAF Developer Guide*.
     *
     * If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys`. This option is not available for other aggregation configurations.
     *
     * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
     */
    public val rateBasedStatement: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement? = builder.rateBasedStatement
    /**
     * A rule statement used to search web request components for a match against a single regular expression.
     */
    public val regexMatchStatement: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement? = builder.regexMatchStatement
    /**
     * A rule statement used to search web request components for matches with regular expressions. To use this, create a RegexPatternSet that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see CreateRegexPatternSet.
     *
     * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
     */
    public val regexPatternSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement? = builder.regexPatternSetReferenceStatement
    /**
     * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
     *
     * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.
     */
    public val ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = builder.ruleGroupReferenceStatement
    /**
     * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
     *
     * If you configure WAF to inspect the request body, WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 bytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 bytes). For CloudFront web ACLs, you can increase the limit in the web ACL `AssociationConfig`, for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size.
     *
     * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
     */
    public val sizeConstraintStatement: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement? = builder.sizeConstraintStatement
    /**
     * A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
     */
    public val sqliMatchStatement: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement? = builder.sqliMatchStatement
    /**
     * A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
     */
    public val xssMatchStatement: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement? = builder.xssMatchStatement

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Statement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Statement(")
        append("andStatement=$andStatement,")
        append("byteMatchStatement=$byteMatchStatement,")
        append("geoMatchStatement=$geoMatchStatement,")
        append("ipSetReferenceStatement=$ipSetReferenceStatement,")
        append("labelMatchStatement=$labelMatchStatement,")
        append("managedRuleGroupStatement=$managedRuleGroupStatement,")
        append("notStatement=$notStatement,")
        append("orStatement=$orStatement,")
        append("rateBasedStatement=$rateBasedStatement,")
        append("regexMatchStatement=$regexMatchStatement,")
        append("regexPatternSetReferenceStatement=$regexPatternSetReferenceStatement,")
        append("ruleGroupReferenceStatement=$ruleGroupReferenceStatement,")
        append("sizeConstraintStatement=$sizeConstraintStatement,")
        append("sqliMatchStatement=$sqliMatchStatement,")
        append("xssMatchStatement=$xssMatchStatement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = andStatement?.hashCode() ?: 0
        result = 31 * result + (byteMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (geoMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (ipSetReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (labelMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (managedRuleGroupStatement?.hashCode() ?: 0)
        result = 31 * result + (notStatement?.hashCode() ?: 0)
        result = 31 * result + (orStatement?.hashCode() ?: 0)
        result = 31 * result + (rateBasedStatement?.hashCode() ?: 0)
        result = 31 * result + (regexMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (regexPatternSetReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (sizeConstraintStatement?.hashCode() ?: 0)
        result = 31 * result + (sqliMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (xssMatchStatement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Statement

        if (andStatement != other.andStatement) return false
        if (byteMatchStatement != other.byteMatchStatement) return false
        if (geoMatchStatement != other.geoMatchStatement) return false
        if (ipSetReferenceStatement != other.ipSetReferenceStatement) return false
        if (labelMatchStatement != other.labelMatchStatement) return false
        if (managedRuleGroupStatement != other.managedRuleGroupStatement) return false
        if (notStatement != other.notStatement) return false
        if (orStatement != other.orStatement) return false
        if (rateBasedStatement != other.rateBasedStatement) return false
        if (regexMatchStatement != other.regexMatchStatement) return false
        if (regexPatternSetReferenceStatement != other.regexPatternSetReferenceStatement) return false
        if (ruleGroupReferenceStatement != other.ruleGroupReferenceStatement) return false
        if (sizeConstraintStatement != other.sizeConstraintStatement) return false
        if (sqliMatchStatement != other.sqliMatchStatement) return false
        if (xssMatchStatement != other.xssMatchStatement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Statement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A logical rule statement used to combine other rule statements with AND logic. You provide more than one Statement within the `AndStatement`.
         */
        public var andStatement: aws.sdk.kotlin.services.wafv2.model.AndStatement? = null
        /**
         * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is called a string match statement.
         */
        public var byteMatchStatement: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement? = null
        /**
         * A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.
         * + To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
         * + Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.
         *
         * WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig`.
         *
         * If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>`.
         *
         * If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>`.
         *
         * For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        public var geoMatchStatement: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement? = null
        /**
         * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an IPSet that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see CreateIPSet.
         *
         * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
         */
        public var ipSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement? = null
        /**
         * A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
         *
         * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement.
         */
        public var labelMatchStatement: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement? = null
        /**
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
         *
         * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a managed rule group inside another rule group. You can only reference a managed rule group as a top-level statement within a rule that you define in a web ACL.
         *
         * You are charged additional fees when you use the WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet`, the WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet`, or the WAF Fraud Control account creation fraud prevention (ACFP) managed rule group `AWSManagedRulesACFPRuleSet`. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
         */
        public var managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = null
        /**
         * A logical rule statement used to negate the results of another rule statement. You provide one Statement within the `NotStatement`.
         */
        public var notStatement: aws.sdk.kotlin.services.wafv2.model.NotStatement? = null
        /**
         * A logical rule statement used to combine other rule statements with OR logic. You provide more than one Statement within the `OrStatement`.
         */
        public var orStatement: aws.sdk.kotlin.services.wafv2.model.OrStatement? = null
        /**
         * A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
         *
         * You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.
         *
         * Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.
         *
         * For example, assume the rule evaluates web requests with the following IP address and HTTP method values:
         * + IP address 10.1.1.1, HTTP method POST
         * + IP address 10.1.1.1, HTTP method GET
         * + IP address 127.0.0.0, HTTP method POST
         * + IP address 10.1.1.1, HTTP method GET
         *
         * The rule would create different aggregation instances according to your aggregation criteria, for example:
         * + If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
         *    + IP address 10.1.1.1: count 3
         *    + IP address 127.0.0.0: count 1
         * + If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
         *    + HTTP method POST: count 2
         *    + HTTP method GET: count 2
         * + If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
         *    + IP address 10.1.1.1, HTTP method POST: count 1
         *    + IP address 10.1.1.1, HTTP method GET: count 2
         *    + IP address 127.0.0.0, HTTP method POST: count 1
         *
         * For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which WAF counts and rate-limits individually.
         *
         * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.
         *
         * You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement`. You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
         *
         * For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *WAF Developer Guide*.
         *
         * If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys`. This option is not available for other aggregation configurations.
         *
         * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
         */
        public var rateBasedStatement: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement? = null
        /**
         * A rule statement used to search web request components for a match against a single regular expression.
         */
        public var regexMatchStatement: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement? = null
        /**
         * A rule statement used to search web request components for matches with regular expressions. To use this, create a RegexPatternSet that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see CreateRegexPatternSet.
         *
         * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
         */
        public var regexPatternSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement? = null
        /**
         * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
         *
         * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.
         */
        public var ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = null
        /**
         * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
         *
         * If you configure WAF to inspect the request body, WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 bytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 bytes). For CloudFront web ACLs, you can increase the limit in the web ACL `AssociationConfig`, for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size.
         *
         * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
         */
        public var sizeConstraintStatement: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement? = null
        /**
         * A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
         */
        public var sqliMatchStatement: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement? = null
        /**
         * A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
         */
        public var xssMatchStatement: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Statement) : this() {
            this.andStatement = x.andStatement
            this.byteMatchStatement = x.byteMatchStatement
            this.geoMatchStatement = x.geoMatchStatement
            this.ipSetReferenceStatement = x.ipSetReferenceStatement
            this.labelMatchStatement = x.labelMatchStatement
            this.managedRuleGroupStatement = x.managedRuleGroupStatement
            this.notStatement = x.notStatement
            this.orStatement = x.orStatement
            this.rateBasedStatement = x.rateBasedStatement
            this.regexMatchStatement = x.regexMatchStatement
            this.regexPatternSetReferenceStatement = x.regexPatternSetReferenceStatement
            this.ruleGroupReferenceStatement = x.ruleGroupReferenceStatement
            this.sizeConstraintStatement = x.sizeConstraintStatement
            this.sqliMatchStatement = x.sqliMatchStatement
            this.xssMatchStatement = x.xssMatchStatement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Statement = Statement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AndStatement] inside the given [block]
         */
        public fun andStatement(block: aws.sdk.kotlin.services.wafv2.model.AndStatement.Builder.() -> kotlin.Unit) {
            this.andStatement = aws.sdk.kotlin.services.wafv2.model.AndStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement] inside the given [block]
         */
        public fun byteMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement.Builder.() -> kotlin.Unit) {
            this.byteMatchStatement = aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement] inside the given [block]
         */
        public fun geoMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement.Builder.() -> kotlin.Unit) {
            this.geoMatchStatement = aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement] inside the given [block]
         */
        public fun ipSetReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement.Builder.() -> kotlin.Unit) {
            this.ipSetReferenceStatement = aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement] inside the given [block]
         */
        public fun labelMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement.Builder.() -> kotlin.Unit) {
            this.labelMatchStatement = aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement] inside the given [block]
         */
        public fun managedRuleGroupStatement(block: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.Builder.() -> kotlin.Unit) {
            this.managedRuleGroupStatement = aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.NotStatement] inside the given [block]
         */
        public fun notStatement(block: aws.sdk.kotlin.services.wafv2.model.NotStatement.Builder.() -> kotlin.Unit) {
            this.notStatement = aws.sdk.kotlin.services.wafv2.model.NotStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.OrStatement] inside the given [block]
         */
        public fun orStatement(block: aws.sdk.kotlin.services.wafv2.model.OrStatement.Builder.() -> kotlin.Unit) {
            this.orStatement = aws.sdk.kotlin.services.wafv2.model.OrStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateBasedStatement] inside the given [block]
         */
        public fun rateBasedStatement(block: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement.Builder.() -> kotlin.Unit) {
            this.rateBasedStatement = aws.sdk.kotlin.services.wafv2.model.RateBasedStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement] inside the given [block]
         */
        public fun regexMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement.Builder.() -> kotlin.Unit) {
            this.regexMatchStatement = aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement] inside the given [block]
         */
        public fun regexPatternSetReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement.Builder.() -> kotlin.Unit) {
            this.regexPatternSetReferenceStatement = aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement] inside the given [block]
         */
        public fun ruleGroupReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.Builder.() -> kotlin.Unit) {
            this.ruleGroupReferenceStatement = aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement] inside the given [block]
         */
        public fun sizeConstraintStatement(block: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement.Builder.() -> kotlin.Unit) {
            this.sizeConstraintStatement = aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement] inside the given [block]
         */
        public fun sqliMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement.Builder.() -> kotlin.Unit) {
            this.sqliMatchStatement = aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.XssMatchStatement] inside the given [block]
         */
        public fun xssMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement.Builder.() -> kotlin.Unit) {
            this.xssMatchStatement = aws.sdk.kotlin.services.wafv2.model.XssMatchStatement.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
