// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Action setting to use in the place of a rule action that is configured inside the rule group. You specify one override for each rule whose action you want to change.
 *
 * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
 */
public class RuleActionOverride private constructor(builder: Builder) {
    /**
     * The override action to use, in place of the configured action of the rule in the rule group.
     */
    public val actionToUse: aws.sdk.kotlin.services.wafv2.model.RuleAction? = builder.actionToUse
    /**
     * The name of the rule to override.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleActionOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleActionOverride(")
        append("actionToUse=$actionToUse,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionToUse?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleActionOverride

        if (actionToUse != other.actionToUse) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleActionOverride = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The override action to use, in place of the configured action of the rule in the rule group.
         */
        public var actionToUse: aws.sdk.kotlin.services.wafv2.model.RuleAction? = null
        /**
         * The name of the rule to override.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleActionOverride) : this() {
            this.actionToUse = x.actionToUse
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleActionOverride = RuleActionOverride(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RuleAction] inside the given [block]
         */
        public fun actionToUse(block: aws.sdk.kotlin.services.wafv2.model.RuleAction.Builder.() -> kotlin.Unit) {
            this.actionToUse = aws.sdk.kotlin.services.wafv2.model.RuleAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
