// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A single rule, which you can use in a WebACL or RuleGroup to identify web requests that you want to manage in some way. Each rule includes one top-level Statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
     *
     * This is used only for rules whose statements do not reference a rule group. Rule statements that reference a rule group include `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement`.
     *
     * You must specify either this `Action` setting or the rule `OverrideAction` setting, but not both:
     * + If the rule statement does not reference a rule group, use this rule action setting and not the rule override action setting.
     * + If the rule statement references a rule group, use the override action setting and not this action setting.
     */
    public val action: aws.sdk.kotlin.services.wafv2.model.RuleAction? = builder.action
    /**
     * Specifies how WAF should handle `CAPTCHA` evaluations. If you don't specify this, WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
     */
    public val captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = builder.captchaConfig
    /**
     * Specifies how WAF should handle `Challenge` evaluations. If you don't specify this, WAF uses the challenge configuration that's defined for the web ACL.
     */
    public val challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = builder.challengeConfig
    /**
     * The name of the rule.
     *
     * If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. WAF doesn't automatically update the metric name when you update the rule name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only.
     *
     * You can only use this for rule statements that reference a rule group, like `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement`.
     *
     * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with `Count` action, in your rule group reference statement settings.
     */
    public val overrideAction: aws.sdk.kotlin.services.wafv2.model.OverrideAction? = builder.overrideAction
    /**
     * If you define more than one `Rule` in a `WebACL`, WAF evaluates each request against the `Rules` in order based on the value of `Priority`. WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * Labels to apply to web requests that match the rule match statement. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
     *
     * Rules that run after this rule in the web ACL can match against these labels using a `LabelMatchStatement`.
     *
     * For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:
     * + Separate each component of the label with a colon.
     * + Each namespace or name can have up to 128 characters.
     * + You can specify up to 5 namespaces in a label.
     * + Don't use the following reserved words in your label specification: `aws`, `waf`, `managed`, `rulegroup`, `webacl`, `regexpatternset`, or `ipset`.
     *
     * For example, `myLabelName` or `nameSpace1:nameSpace2:myLabelName`.
     */
    public val ruleLabels: List<Label>? = builder.ruleLabels
    /**
     * The WAF processing statement for the rule, for example ByteMatchStatement or SizeConstraintStatement.
     */
    public val statement: aws.sdk.kotlin.services.wafv2.model.Statement? = builder.statement
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     *
     * If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. WAF doesn't automatically update the metric name.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("action=$action,")
        append("captchaConfig=$captchaConfig,")
        append("challengeConfig=$challengeConfig,")
        append("name=$name,")
        append("overrideAction=$overrideAction,")
        append("priority=$priority,")
        append("ruleLabels=$ruleLabels,")
        append("statement=$statement,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (captchaConfig?.hashCode() ?: 0)
        result = 31 * result + (challengeConfig?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (overrideAction?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (ruleLabels?.hashCode() ?: 0)
        result = 31 * result + (statement?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (action != other.action) return false
        if (captchaConfig != other.captchaConfig) return false
        if (challengeConfig != other.challengeConfig) return false
        if (name != other.name) return false
        if (overrideAction != other.overrideAction) return false
        if (priority != other.priority) return false
        if (ruleLabels != other.ruleLabels) return false
        if (statement != other.statement) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Rule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
         *
         * This is used only for rules whose statements do not reference a rule group. Rule statements that reference a rule group include `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement`.
         *
         * You must specify either this `Action` setting or the rule `OverrideAction` setting, but not both:
         * + If the rule statement does not reference a rule group, use this rule action setting and not the rule override action setting.
         * + If the rule statement references a rule group, use the override action setting and not this action setting.
         */
        public var action: aws.sdk.kotlin.services.wafv2.model.RuleAction? = null
        /**
         * Specifies how WAF should handle `CAPTCHA` evaluations. If you don't specify this, WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
         */
        public var captchaConfig: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig? = null
        /**
         * Specifies how WAF should handle `Challenge` evaluations. If you don't specify this, WAF uses the challenge configuration that's defined for the web ACL.
         */
        public var challengeConfig: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig? = null
        /**
         * The name of the rule.
         *
         * If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. WAF doesn't automatically update the metric name when you update the rule name.
         */
        public var name: kotlin.String? = null
        /**
         * The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only.
         *
         * You can only use this for rule statements that reference a rule group, like `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement`.
         *
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with `Count` action, in your rule group reference statement settings.
         */
        public var overrideAction: aws.sdk.kotlin.services.wafv2.model.OverrideAction? = null
        /**
         * If you define more than one `Rule` in a `WebACL`, WAF evaluates each request against the `Rules` in order based on the value of `Priority`. WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
         */
        public var priority: kotlin.Int = 0
        /**
         * Labels to apply to web requests that match the rule match statement. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
         *
         * Rules that run after this rule in the web ACL can match against these labels using a `LabelMatchStatement`.
         *
         * For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:
         * + Separate each component of the label with a colon.
         * + Each namespace or name can have up to 128 characters.
         * + You can specify up to 5 namespaces in a label.
         * + Don't use the following reserved words in your label specification: `aws`, `waf`, `managed`, `rulegroup`, `webacl`, `regexpatternset`, or `ipset`.
         *
         * For example, `myLabelName` or `nameSpace1:nameSpace2:myLabelName`.
         */
        public var ruleLabels: List<Label>? = null
        /**
         * The WAF processing statement for the rule, for example ByteMatchStatement or SizeConstraintStatement.
         */
        public var statement: aws.sdk.kotlin.services.wafv2.model.Statement? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         *
         * If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. WAF doesn't automatically update the metric name.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Rule) : this() {
            this.action = x.action
            this.captchaConfig = x.captchaConfig
            this.challengeConfig = x.challengeConfig
            this.name = x.name
            this.overrideAction = x.overrideAction
            this.priority = x.priority
            this.ruleLabels = x.ruleLabels
            this.statement = x.statement
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Rule = Rule(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RuleAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.wafv2.model.RuleAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.wafv2.model.RuleAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaConfig] inside the given [block]
         */
        public fun captchaConfig(block: aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.Builder.() -> kotlin.Unit) {
            this.captchaConfig = aws.sdk.kotlin.services.wafv2.model.CaptchaConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ChallengeConfig] inside the given [block]
         */
        public fun challengeConfig(block: aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.Builder.() -> kotlin.Unit) {
            this.challengeConfig = aws.sdk.kotlin.services.wafv2.model.ChallengeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.OverrideAction] inside the given [block]
         */
        public fun overrideAction(block: aws.sdk.kotlin.services.wafv2.model.OverrideAction.Builder.() -> kotlin.Unit) {
            this.overrideAction = aws.sdk.kotlin.services.wafv2.model.OverrideAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Statement] inside the given [block]
         */
        public fun statement(block: aws.sdk.kotlin.services.wafv2.model.Statement.Builder.() -> kotlin.Unit) {
            this.statement = aws.sdk.kotlin.services.wafv2.model.Statement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
