// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Configures inspection of the response header. This is part of the `ResponseInspection` configuration for `AWSManagedRulesATPRuleSet` and `AWSManagedRulesACFPRuleSet`.
 *
 * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
 */
public class ResponseInspectionHeader private constructor(builder: Builder) {
    /**
     * Values in the response header with the specified name that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
     *
     * JSON examples: `"FailureValues": [ "LoginFailed", "Failed login" ]` and `"FailureValues": [ "AccountCreationFailed" ]`
     */
    public val failureValues: List<String> = requireNotNull(builder.failureValues) { "A non-null value must be provided for failureValues" }
    /**
     * The name of the header to match against. The name must be an exact match, including case.
     *
     * JSON example: `"Name": [ "RequestResult" ]`
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Values in the response header with the specified name that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
     *
     * JSON examples: `"SuccessValues": [ "LoginPassed", "Successful login" ]` and `"SuccessValues": [ "AccountCreated", "Successful account creation" ]`
     */
    public val successValues: List<String> = requireNotNull(builder.successValues) { "A non-null value must be provided for successValues" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionHeader = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseInspectionHeader(")
        append("failureValues=$failureValues,")
        append("name=$name,")
        append("successValues=$successValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureValues.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (successValues.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseInspectionHeader

        if (failureValues != other.failureValues) return false
        if (name != other.name) return false
        if (successValues != other.successValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionHeader = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Values in the response header with the specified name that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
         *
         * JSON examples: `"FailureValues": [ "LoginFailed", "Failed login" ]` and `"FailureValues": [ "AccountCreationFailed" ]`
         */
        public var failureValues: List<String>? = null
        /**
         * The name of the header to match against. The name must be an exact match, including case.
         *
         * JSON example: `"Name": [ "RequestResult" ]`
         */
        public var name: kotlin.String? = null
        /**
         * Values in the response header with the specified name that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
         *
         * JSON examples: `"SuccessValues": [ "LoginPassed", "Successful login" ]` and `"SuccessValues": [ "AccountCreated", "Successful account creation" ]`
         */
        public var successValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ResponseInspectionHeader) : this() {
            this.failureValues = x.failureValues
            this.name = x.name
            this.successValues = x.successValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ResponseInspectionHeader = ResponseInspectionHeader(this)

        internal fun correctErrors(): Builder {
            if (failureValues == null) failureValues = emptyList()
            if (name == null) name = ""
            if (successValues == null) successValues = emptyList()
            return this
        }
    }
}
