// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Specifies a cookie as an aggregate key for a rate-based rule. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
 */
public class RateLimitCookie private constructor(builder: Builder) {
    /**
     * The name of the cookie to use.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
     */
    public val textTransformations: List<TextTransformation> = requireNotNull(builder.textTransformations) { "A non-null value must be provided for textTransformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RateLimitCookie = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateLimitCookie(")
        append("name=$name,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (textTransformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RateLimitCookie

        if (name != other.name) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RateLimitCookie = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the cookie to use.
         */
        public var name: kotlin.String? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RateLimitCookie) : this() {
            this.name = x.name
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RateLimitCookie = RateLimitCookie(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (textTransformations == null) textTransformations = emptyList()
            return this
        }
    }
}
