// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The set of IP addresses that are currently blocked for a RateBasedStatement. This is only available for rate-based rules that aggregate on just the IP address, with the `AggregateKeyType` set to `IP` or `FORWARDED_IP`.
 *
 * A rate-based rule applies its rule action to requests from IP addresses that are in the rule's managed keys list and that match the rule's scope-down statement. When a rule has no scope-down statement, it applies the action to all requests from the IP addresses that are in the list. The rule applies its rule action to rate limit the matching requests. The action is usually Block but it can be any valid rule action except for Allow.
 *
 * The maximum number of IP addresses that can be rate limited by a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, WAF limits those with the highest rates.
 */
public class RateBasedStatementManagedKeysIpSet private constructor(builder: Builder) {
    /**
     * The IP addresses that are currently blocked.
     */
    public val addresses: List<String>? = builder.addresses
    /**
     * The version of the IP addresses, either `IPV4` or `IPV6`.
     */
    public val ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = builder.ipAddressVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementManagedKeysIpSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateBasedStatementManagedKeysIpSet(")
        append("addresses=$addresses,")
        append("ipAddressVersion=$ipAddressVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (ipAddressVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RateBasedStatementManagedKeysIpSet

        if (addresses != other.addresses) return false
        if (ipAddressVersion != other.ipAddressVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementManagedKeysIpSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP addresses that are currently blocked.
         */
        public var addresses: List<String>? = null
        /**
         * The version of the IP addresses, either `IPV4` or `IPV6`.
         */
        public var ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RateBasedStatementManagedKeysIpSet) : this() {
            this.addresses = x.addresses
            this.ipAddressVersion = x.ipAddressVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RateBasedStatementManagedKeysIpSet = RateBasedStatementManagedKeysIpSet(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
