// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The properties of a managed product, such as an Amazon Web Services Managed Rules rule group or an Amazon Web Services Marketplace managed rule group.
 */
public class ManagedProductDescriptor private constructor(builder: Builder) {
    /**
     * Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web Services Managed Rules rule groups that are used for WAF intelligent threat mitigation.
     */
    public val isAdvancedManagedRuleSet: kotlin.Boolean = builder.isAdvancedManagedRuleSet
    /**
     * Indicates whether the rule group is versioned.
     */
    public val isVersioningSupported: kotlin.Boolean = builder.isVersioningSupported
    /**
     * The name of the managed rule group. For example, `AWSManagedRulesAnonymousIpList` or `AWSManagedRulesATPRuleSet`.
     */
    public val managedRuleSetName: kotlin.String? = builder.managedRuleSetName
    /**
     * A short description of the managed rule group.
     */
    public val productDescription: kotlin.String? = builder.productDescription
    /**
     * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val productId: kotlin.String? = builder.productId
    /**
     * For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
     */
    public val productLink: kotlin.String? = builder.productLink
    /**
     * The display name for the managed rule group. For example, `Anonymous IP list` or `Account takeover prevention`.
     */
    public val productTitle: kotlin.String? = builder.productTitle
    /**
     * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
     */
    public val vendorName: kotlin.String? = builder.vendorName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedProductDescriptor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedProductDescriptor(")
        append("isAdvancedManagedRuleSet=$isAdvancedManagedRuleSet,")
        append("isVersioningSupported=$isVersioningSupported,")
        append("managedRuleSetName=$managedRuleSetName,")
        append("productDescription=$productDescription,")
        append("productId=$productId,")
        append("productLink=$productLink,")
        append("productTitle=$productTitle,")
        append("snsTopicArn=$snsTopicArn,")
        append("vendorName=$vendorName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isAdvancedManagedRuleSet.hashCode()
        result = 31 * result + (isVersioningSupported.hashCode())
        result = 31 * result + (managedRuleSetName?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (productLink?.hashCode() ?: 0)
        result = 31 * result + (productTitle?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedProductDescriptor

        if (isAdvancedManagedRuleSet != other.isAdvancedManagedRuleSet) return false
        if (isVersioningSupported != other.isVersioningSupported) return false
        if (managedRuleSetName != other.managedRuleSetName) return false
        if (productDescription != other.productDescription) return false
        if (productId != other.productId) return false
        if (productLink != other.productLink) return false
        if (productTitle != other.productTitle) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (vendorName != other.vendorName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedProductDescriptor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web Services Managed Rules rule groups that are used for WAF intelligent threat mitigation.
         */
        public var isAdvancedManagedRuleSet: kotlin.Boolean = false
        /**
         * Indicates whether the rule group is versioned.
         */
        public var isVersioningSupported: kotlin.Boolean = false
        /**
         * The name of the managed rule group. For example, `AWSManagedRulesAnonymousIpList` or `AWSManagedRulesATPRuleSet`.
         */
        public var managedRuleSetName: kotlin.String? = null
        /**
         * A short description of the managed rule group.
         */
        public var productDescription: kotlin.String? = null
        /**
         * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var productId: kotlin.String? = null
        /**
         * For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
         */
        public var productLink: kotlin.String? = null
        /**
         * The display name for the managed rule group. For example, `Anonymous IP list` or `Account takeover prevention`.
         */
        public var productTitle: kotlin.String? = null
        /**
         * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
         */
        public var vendorName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedProductDescriptor) : this() {
            this.isAdvancedManagedRuleSet = x.isAdvancedManagedRuleSet
            this.isVersioningSupported = x.isVersioningSupported
            this.managedRuleSetName = x.managedRuleSetName
            this.productDescription = x.productDescription
            this.productId = x.productId
            this.productLink = x.productLink
            this.productTitle = x.productTitle
            this.snsTopicArn = x.snsTopicArn
            this.vendorName = x.vendorName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedProductDescriptor = ManagedProductDescriptor(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
