// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Inspect all headers in the web request. You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.
 *
 * This is used to indicate the web request component to inspect, in the FieldToMatch specification.
 *
 * If you want to inspect just the value of a single header, use the `SingleHeader``FieldToMatch` setting instead.
 *
 * Example JSON: `"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }`
 */
public class Headers private constructor(builder: Builder) {
    /**
     * The filter to use to identify the subset of headers to inspect in a web request.
     *
     * You must specify exactly one setting: either `All`, `IncludedHeaders`, or `ExcludedHeaders`.
     *
     * Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
     */
    public val matchPattern: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern? = builder.matchPattern
    /**
     * The parts of the headers to match with the rule inspection criteria. If you specify `All`, WAF inspects both keys and values.
     */
    public val matchScope: aws.sdk.kotlin.services.wafv2.model.MapMatchScope = requireNotNull(builder.matchScope) { "A non-null value must be provided for matchScope" }
    /**
     * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
     *
     * The options for oversize handling are the following:
     * + `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     */
    public val oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling = requireNotNull(builder.oversizeHandling) { "A non-null value must be provided for oversizeHandling" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Headers = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Headers(")
        append("matchPattern=$matchPattern,")
        append("matchScope=$matchScope,")
        append("oversizeHandling=$oversizeHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchPattern?.hashCode() ?: 0
        result = 31 * result + (matchScope.hashCode())
        result = 31 * result + (oversizeHandling.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Headers

        if (matchPattern != other.matchPattern) return false
        if (matchScope != other.matchScope) return false
        if (oversizeHandling != other.oversizeHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Headers = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filter to use to identify the subset of headers to inspect in a web request.
         *
         * You must specify exactly one setting: either `All`, `IncludedHeaders`, or `ExcludedHeaders`.
         *
         * Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
         */
        public var matchPattern: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern? = null
        /**
         * The parts of the headers to match with the rule inspection criteria. If you specify `All`, WAF inspects both keys and values.
         */
        public var matchScope: aws.sdk.kotlin.services.wafv2.model.MapMatchScope? = null
        /**
         * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
         *
         * The options for oversize handling are the following:
         * + `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         */
        public var oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Headers) : this() {
            this.matchPattern = x.matchPattern
            this.matchScope = x.matchScope
            this.oversizeHandling = x.oversizeHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Headers = Headers(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern] inside the given [block]
         */
        public fun matchPattern(block: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern.Builder.() -> kotlin.Unit) {
            this.matchPattern = aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (matchScope == null) matchScope = MapMatchScope.SdkUnknown("no value provided")
            if (oversizeHandling == null) oversizeHandling = OversizeHandling.SdkUnknown("no value provided")
            return this
        }
    }
}
