// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



public class DescribeManagedRuleGroupResponse private constructor(builder: Builder) {
    /**
     * The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the `RuleLabels` for a Rule.
     */
    public val availableLabels: List<LabelSummary>? = builder.availableLabels
    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see [WAF web ACL capacity units (WCU)](https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html) in the *WAF Developer Guide*.
     */
    public val capacity: kotlin.Long? = builder.capacity
    /**
     * The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a `LabelMatchStatement` specification, in the Statement definition of a rule.
     */
    public val consumedLabels: List<LabelSummary>? = builder.consumedLabels
    /**
     * The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.
     * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
     * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
     */
    public val labelNamespace: kotlin.String? = builder.labelNamespace
    /**
     *
     */
    public val rules: List<RuleSummary>? = builder.rules
    /**
     * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The managed rule group's version.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeManagedRuleGroupResponse(")
        append("availableLabels=$availableLabels,")
        append("capacity=$capacity,")
        append("consumedLabels=$consumedLabels,")
        append("labelNamespace=$labelNamespace,")
        append("rules=$rules,")
        append("snsTopicArn=$snsTopicArn,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableLabels?.hashCode() ?: 0
        result = 31 * result + (capacity?.hashCode() ?: 0)
        result = 31 * result + (consumedLabels?.hashCode() ?: 0)
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeManagedRuleGroupResponse

        if (availableLabels != other.availableLabels) return false
        if (capacity != other.capacity) return false
        if (consumedLabels != other.consumedLabels) return false
        if (labelNamespace != other.labelNamespace) return false
        if (rules != other.rules) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the `RuleLabels` for a Rule.
         */
        public var availableLabels: List<LabelSummary>? = null
        /**
         * The web ACL capacity units (WCUs) required for this rule group.
         *
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see [WAF web ACL capacity units (WCU)](https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html) in the *WAF Developer Guide*.
         */
        public var capacity: kotlin.Long? = null
        /**
         * The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a `LabelMatchStatement` specification, in the Statement definition of a rule.
         */
        public var consumedLabels: List<LabelSummary>? = null
        /**
         * The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.
         * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
         * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
         */
        public var labelNamespace: kotlin.String? = null
        /**
         *
         */
        public var rules: List<RuleSummary>? = null
        /**
         * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The managed rule group's version.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse) : this() {
            this.availableLabels = x.availableLabels
            this.capacity = x.capacity
            this.consumedLabels = x.consumedLabels
            this.labelNamespace = x.labelNamespace
            this.rules = x.rules
            this.snsTopicArn = x.snsTopicArn
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse = DescribeManagedRuleGroupResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
