// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information for a single API key.
 *
 * API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information about the CAPTCHA JavaScript integration, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
 */
public class ApiKeySummary private constructor(builder: Builder) {
    /**
     * The generated, encrypted API key. You can copy this for use in your JavaScript CAPTCHA integration.
     */
    public val apiKey: kotlin.String? = builder.apiKey
    /**
     * The date and time that the key was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The token domains that are defined in this API key.
     */
    public val tokenDomains: List<String>? = builder.tokenDomains
    /**
     * Internal value used by WAF to manage the key.
     */
    public val version: kotlin.Int = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ApiKeySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiKeySummary(")
        append("apiKey=$apiKey,")
        append("creationTimestamp=$creationTimestamp,")
        append("tokenDomains=$tokenDomains,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKey?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (tokenDomains?.hashCode() ?: 0)
        result = 31 * result + (version)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiKeySummary

        if (apiKey != other.apiKey) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (tokenDomains != other.tokenDomains) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ApiKeySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The generated, encrypted API key. You can copy this for use in your JavaScript CAPTCHA integration.
         */
        public var apiKey: kotlin.String? = null
        /**
         * The date and time that the key was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The token domains that are defined in this API key.
         */
        public var tokenDomains: List<String>? = null
        /**
         * Internal value used by WAF to manage the key.
         */
        public var version: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ApiKeySummary) : this() {
            this.apiKey = x.apiKey
            this.creationTimestamp = x.creationTimestamp
            this.tokenDomains = x.tokenDomains
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ApiKeySummary = ApiKeySummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
