// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains the identifier and the name or description of the WebACL.
 */
public class WebAclSummary private constructor(builder: Builder) {
    /**
     * A friendly name or description of the WebACL. You can't change the name of a `WebACL` after you create it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A unique identifier for a `WebACL`. You use `WebACLId` to get information about a `WebACL` (see GetWebACL), update a `WebACL` (see UpdateWebACL), and delete a `WebACL` from AWS WAF (see DeleteWebACL).
     *
     * `WebACLId` is returned by CreateWebACL and by ListWebACLs.
     */
    public val webAclId: kotlin.String = requireNotNull(builder.webAclId) { "A non-null value must be provided for webAclId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.WebAclSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebAclSummary(")
        append("name=$name,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (webAclId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebAclSummary

        if (name != other.name) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.WebAclSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description of the WebACL. You can't change the name of a `WebACL` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `WebACL`. You use `WebACLId` to get information about a `WebACL` (see GetWebACL), update a `WebACL` (see UpdateWebACL), and delete a `WebACL` from AWS WAF (see DeleteWebACL).
         *
         * `WebACLId` is returned by CreateWebACL and by ListWebACLs.
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.WebAclSummary) : this() {
            this.name = x.name
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.WebAclSummary = WebAclSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (webAclId == null) webAclId = ""
            return this
        }
    }
}
