// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains the `Rules` that identify the requests that you want to allow, block, or count. In a `WebACL`, you also specify a default action (`ALLOW` or `BLOCK`), and the action for each `Rule` that you add to a `WebACL`, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the `WebACL` with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one `Rule` to a `WebACL`, a request needs to match only one of the specifications to be allowed, blocked, or counted. For more information, see UpdateWebACL.
 */
public class WebAcl private constructor(builder: Builder) {
    /**
     * The action to perform if none of the `Rules` contained in the `WebACL` match. The action is specified by the WafAction object.
     */
    public val defaultAction: aws.sdk.kotlin.services.wafregional.model.WafAction? = builder.defaultAction
    /**
     * A friendly name or description for the metrics for this `WebACL`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change `MetricName` after you create the `WebACL`.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * A friendly name or description of the `WebACL`. You can't change the name of a `WebACL` after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An array that contains the action for each `Rule` in a `WebACL`, the priority of the `Rule`, and the ID of the `Rule`.
     */
    public val rules: List<ActivatedRule> = requireNotNull(builder.rules) { "A non-null value must be provided for rules" }
    /**
     * Tha Amazon Resource Name (ARN) of the web ACL.
     */
    public val webAclArn: kotlin.String? = builder.webAclArn
    /**
     * A unique identifier for a `WebACL`. You use `WebACLId` to get information about a `WebACL` (see GetWebACL), update a `WebACL` (see UpdateWebACL), and delete a `WebACL` from AWS WAF (see DeleteWebACL).
     *
     * `WebACLId` is returned by CreateWebACL and by ListWebACLs.
     */
    public val webAclId: kotlin.String = requireNotNull(builder.webAclId) { "A non-null value must be provided for webAclId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.WebAcl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebAcl(")
        append("defaultAction=$defaultAction,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("rules=$rules,")
        append("webAclArn=$webAclArn,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultAction?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules.hashCode())
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        result = 31 * result + (webAclId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebAcl

        if (defaultAction != other.defaultAction) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (webAclArn != other.webAclArn) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.WebAcl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to perform if none of the `Rules` contained in the `WebACL` match. The action is specified by the WafAction object.
         */
        public var defaultAction: aws.sdk.kotlin.services.wafregional.model.WafAction? = null
        /**
         * A friendly name or description for the metrics for this `WebACL`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change `MetricName` after you create the `WebACL`.
         */
        public var metricName: kotlin.String? = null
        /**
         * A friendly name or description of the `WebACL`. You can't change the name of a `WebACL` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * An array that contains the action for each `Rule` in a `WebACL`, the priority of the `Rule`, and the ID of the `Rule`.
         */
        public var rules: List<ActivatedRule>? = null
        /**
         * Tha Amazon Resource Name (ARN) of the web ACL.
         */
        public var webAclArn: kotlin.String? = null
        /**
         * A unique identifier for a `WebACL`. You use `WebACLId` to get information about a `WebACL` (see GetWebACL), update a `WebACL` (see UpdateWebACL), and delete a `WebACL` from AWS WAF (see DeleteWebACL).
         *
         * `WebACLId` is returned by CreateWebACL and by ListWebACLs.
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.WebAcl) : this() {
            this.defaultAction = x.defaultAction
            this.metricName = x.metricName
            this.name = x.name
            this.rules = x.rules
            this.webAclArn = x.webAclArn
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.WebAcl = WebAcl(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.WafAction] inside the given [block]
         */
        public fun defaultAction(block: aws.sdk.kotlin.services.wafregional.model.WafAction.Builder.() -> kotlin.Unit) {
            this.defaultAction = aws.sdk.kotlin.services.wafregional.model.WafAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (rules == null) rules = emptyList()
            if (webAclId == null) webAclId = ""
            return this
        }
    }
}
