// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the part of a web request that you want to inspect for snippets of malicious SQL code and indicates whether you want to add the specification to a SqlInjectionMatchSet or delete it from a `SqlInjectionMatchSet`.
 */
public class SqlInjectionMatchSetUpdate private constructor(builder: Builder) {
    /**
     * Specify `INSERT` to add a SqlInjectionMatchSetUpdate to a SqlInjectionMatchSet. Use `DELETE` to remove a `SqlInjectionMatchSetUpdate` from a `SqlInjectionMatchSet`.
     */
    public val action: aws.sdk.kotlin.services.wafregional.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public val sqlInjectionMatchTuple: aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple? = builder.sqlInjectionMatchTuple

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqlInjectionMatchSetUpdate(")
        append("action=$action,")
        append("sqlInjectionMatchTuple=$sqlInjectionMatchTuple")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (sqlInjectionMatchTuple?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqlInjectionMatchSetUpdate

        if (action != other.action) return false
        if (sqlInjectionMatchTuple != other.sqlInjectionMatchTuple) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchSetUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify `INSERT` to add a SqlInjectionMatchSetUpdate to a SqlInjectionMatchSet. Use `DELETE` to remove a `SqlInjectionMatchSetUpdate` from a `SqlInjectionMatchSet`.
         */
        public var action: aws.sdk.kotlin.services.wafregional.model.ChangeAction? = null
        /**
         * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
         */
        public var sqlInjectionMatchTuple: aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchSetUpdate) : this() {
            this.action = x.action
            this.sqlInjectionMatchTuple = x.sqlInjectionMatchTuple
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchSetUpdate = SqlInjectionMatchSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple] inside the given [block]
         */
        public fun sqlInjectionMatchTuple(block: aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple.Builder.() -> kotlin.Unit) {
            this.sqlInjectionMatchTuple = aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
