// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the part of a web request that you want to inspect the size of and indicates whether you want to add the specification to a SizeConstraintSet or delete it from a `SizeConstraintSet`.
 */
public class SizeConstraintSetUpdate private constructor(builder: Builder) {
    /**
     * Specify `INSERT` to add a SizeConstraintSetUpdate to a SizeConstraintSet. Use `DELETE` to remove a `SizeConstraintSetUpdate` from a `SizeConstraintSet`.
     */
    public val action: aws.sdk.kotlin.services.wafregional.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * Specifies a constraint on the size of a part of the web request. AWS WAF uses the `Size`, `ComparisonOperator`, and `FieldToMatch` to build an expression in the form of "`Size``ComparisonOperator` size in bytes of `FieldToMatch`". If that expression is true, the `SizeConstraint` is considered to match.
     */
    public val sizeConstraint: aws.sdk.kotlin.services.wafregional.model.SizeConstraint? = builder.sizeConstraint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SizeConstraintSetUpdate(")
        append("action=$action,")
        append("sizeConstraint=$sizeConstraint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (sizeConstraint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SizeConstraintSetUpdate

        if (action != other.action) return false
        if (sizeConstraint != other.sizeConstraint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify `INSERT` to add a SizeConstraintSetUpdate to a SizeConstraintSet. Use `DELETE` to remove a `SizeConstraintSetUpdate` from a `SizeConstraintSet`.
         */
        public var action: aws.sdk.kotlin.services.wafregional.model.ChangeAction? = null
        /**
         * Specifies a constraint on the size of a part of the web request. AWS WAF uses the `Size`, `ComparisonOperator`, and `FieldToMatch` to build an expression in the form of "`Size``ComparisonOperator` size in bytes of `FieldToMatch`". If that expression is true, the `SizeConstraint` is considered to match.
         */
        public var sizeConstraint: aws.sdk.kotlin.services.wafregional.model.SizeConstraint? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetUpdate) : this() {
            this.action = x.action
            this.sizeConstraint = x.sizeConstraint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetUpdate = SizeConstraintSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.SizeConstraint] inside the given [block]
         */
        public fun sizeConstraint(block: aws.sdk.kotlin.services.wafregional.model.SizeConstraint.Builder.() -> kotlin.Unit) {
            this.sizeConstraint = aws.sdk.kotlin.services.wafregional.model.SizeConstraint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
