// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The `Id` and `Name` of a `SizeConstraintSet`.
 */
public class SizeConstraintSetSummary private constructor(builder: Builder) {
    /**
     * The name of the `SizeConstraintSet`, if any.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A unique identifier for a `SizeConstraintSet`. You use `SizeConstraintSetId` to get information about a `SizeConstraintSet` (see GetSizeConstraintSet), update a `SizeConstraintSet` (see UpdateSizeConstraintSet), insert a `SizeConstraintSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SizeConstraintSet` from AWS WAF (see DeleteSizeConstraintSet).
     *
     * `SizeConstraintSetId` is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
     */
    public val sizeConstraintSetId: kotlin.String = requireNotNull(builder.sizeConstraintSetId) { "A non-null value must be provided for sizeConstraintSetId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SizeConstraintSetSummary(")
        append("name=$name,")
        append("sizeConstraintSetId=$sizeConstraintSetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (sizeConstraintSetId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SizeConstraintSetSummary

        if (name != other.name) return false
        if (sizeConstraintSetId != other.sizeConstraintSetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the `SizeConstraintSet`, if any.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `SizeConstraintSet`. You use `SizeConstraintSetId` to get information about a `SizeConstraintSet` (see GetSizeConstraintSet), update a `SizeConstraintSet` (see UpdateSizeConstraintSet), insert a `SizeConstraintSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SizeConstraintSet` from AWS WAF (see DeleteSizeConstraintSet).
         *
         * `SizeConstraintSetId` is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
         */
        public var sizeConstraintSetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetSummary) : this() {
            this.name = x.name
            this.sizeConstraintSetId = x.sizeConstraintSetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSetSummary = SizeConstraintSetSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (sizeConstraintSetId == null) sizeConstraintSetId = ""
            return this
        }
    }
}
