// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains the identifier and the friendly name or description of the `Rule`.
 */
public class RuleSummary private constructor(builder: Builder) {
    /**
     * A friendly name or description of the Rule. You can't change the name of a `Rule` after you create it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A unique identifier for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
     *
     * `RuleId` is returned by CreateRule and by ListRules.
     */
    public val ruleId: kotlin.String = requireNotNull(builder.ruleId) { "A non-null value must be provided for ruleId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.RuleSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleSummary(")
        append("name=$name,")
        append("ruleId=$ruleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (ruleId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleSummary

        if (name != other.name) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.RuleSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description of the Rule. You can't change the name of a `Rule` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
         *
         * `RuleId` is returned by CreateRule and by ListRules.
         */
        public var ruleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.RuleSummary) : this() {
            this.name = x.name
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.RuleSummary = RuleSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (ruleId == null) ruleId = ""
            return this
        }
    }
}
