// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * In an UpdateRegexMatchSet request, `RegexMatchSetUpdate` specifies whether to insert or delete a RegexMatchTuple and includes the settings for the `RegexMatchTuple`.
 */
public class RegexMatchSetUpdate private constructor(builder: Builder) {
    /**
     * Specifies whether to insert or delete a RegexMatchTuple.
     */
    public val action: aws.sdk.kotlin.services.wafregional.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify `DELETE` for the value of `Action`, the `RegexMatchTuple` values must exactly match the values in the `RegexMatchTuple` that you want to delete from the `RegexMatchSet`.
     */
    public val regexMatchTuple: aws.sdk.kotlin.services.wafregional.model.RegexMatchTuple? = builder.regexMatchTuple

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.RegexMatchSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexMatchSetUpdate(")
        append("action=$action,")
        append("regexMatchTuple=$regexMatchTuple")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (regexMatchTuple?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexMatchSetUpdate

        if (action != other.action) return false
        if (regexMatchTuple != other.regexMatchTuple) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.RegexMatchSetUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to insert or delete a RegexMatchTuple.
         */
        public var action: aws.sdk.kotlin.services.wafregional.model.ChangeAction? = null
        /**
         * Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify `DELETE` for the value of `Action`, the `RegexMatchTuple` values must exactly match the values in the `RegexMatchTuple` that you want to delete from the `RegexMatchSet`.
         */
        public var regexMatchTuple: aws.sdk.kotlin.services.wafregional.model.RegexMatchTuple? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.RegexMatchSetUpdate) : this() {
            this.action = x.action
            this.regexMatchTuple = x.regexMatchTuple
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.RegexMatchSetUpdate = RegexMatchSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.RegexMatchTuple] inside the given [block]
         */
        public fun regexMatchTuple(block: aws.sdk.kotlin.services.wafregional.model.RegexMatchTuple.Builder.() -> kotlin.Unit) {
            this.regexMatchTuple = aws.sdk.kotlin.services.wafregional.model.RegexMatchTuple.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
