// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * In a GetRegexMatchSet request, `RegexMatchSet` is a complex type that contains the `RegexMatchSetId` and `Name` of a `RegexMatchSet`, and the values that you specified when you updated the `RegexMatchSet`.
 *
 *  The values are contained in a `RegexMatchTuple` object, which specify the parts of web requests that you want AWS WAF to inspect and the values that you want AWS WAF to search for. If a `RegexMatchSet` contains more than one `RegexMatchTuple` object, a request needs to match the settings in only one `ByteMatchTuple` to be considered a match.
 */
public class RegexMatchSet private constructor(builder: Builder) {
    /**
     * A friendly name or description of the RegexMatchSet. You can't change `Name` after you create a `RegexMatchSet`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `RegexMatchSetId` for a `RegexMatchSet`. You use `RegexMatchSetId` to get information about a `RegexMatchSet` (see GetRegexMatchSet), update a `RegexMatchSet` (see UpdateRegexMatchSet), insert a `RegexMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `RegexMatchSet` from AWS WAF (see DeleteRegexMatchSet).
     *
     * `RegexMatchSetId` is returned by CreateRegexMatchSet and by ListRegexMatchSets.
     */
    public val regexMatchSetId: kotlin.String? = builder.regexMatchSetId
    /**
     * Contains an array of RegexMatchTuple objects. Each `RegexMatchTuple` object contains:
     * + The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the `User-Agent` header.
     * + The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see RegexPatternSet.
     * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
     */
    public val regexMatchTuples: List<RegexMatchTuple>? = builder.regexMatchTuples

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.RegexMatchSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexMatchSet(")
        append("name=$name,")
        append("regexMatchSetId=$regexMatchSetId,")
        append("regexMatchTuples=$regexMatchTuples")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (regexMatchSetId?.hashCode() ?: 0)
        result = 31 * result + (regexMatchTuples?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexMatchSet

        if (name != other.name) return false
        if (regexMatchSetId != other.regexMatchSetId) return false
        if (regexMatchTuples != other.regexMatchTuples) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.RegexMatchSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description of the RegexMatchSet. You can't change `Name` after you create a `RegexMatchSet`.
         */
        public var name: kotlin.String? = null
        /**
         * The `RegexMatchSetId` for a `RegexMatchSet`. You use `RegexMatchSetId` to get information about a `RegexMatchSet` (see GetRegexMatchSet), update a `RegexMatchSet` (see UpdateRegexMatchSet), insert a `RegexMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `RegexMatchSet` from AWS WAF (see DeleteRegexMatchSet).
         *
         * `RegexMatchSetId` is returned by CreateRegexMatchSet and by ListRegexMatchSets.
         */
        public var regexMatchSetId: kotlin.String? = null
        /**
         * Contains an array of RegexMatchTuple objects. Each `RegexMatchTuple` object contains:
         * + The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the `User-Agent` header.
         * + The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see RegexPatternSet.
         * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
         */
        public var regexMatchTuples: List<RegexMatchTuple>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.RegexMatchSet) : this() {
            this.name = x.name
            this.regexMatchSetId = x.regexMatchSetId
            this.regexMatchTuples = x.regexMatchTuples
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.RegexMatchSet = RegexMatchSet(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
