// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet, GeoMatchSet, and SizeConstraintSet objects that you want to add to a `Rule` and, for each object, indicates whether you want to negate the settings, for example, requests that do NOT originate from the IP address 192.0.2.44.
 */
public class Predicate private constructor(builder: Builder) {
    /**
     * A unique identifier for a predicate in a `Rule`, such as `ByteMatchSetId` or `IPSetId`. The ID is returned by the corresponding `Create` or `List` command.
     */
    public val dataId: kotlin.String = requireNotNull(builder.dataId) { "A non-null value must be provided for dataId" }
    /**
     * Set `Negated` to `False` if you want AWS WAF to allow, block, or count requests based on the settings in the specified ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example, if an `IPSet` includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
     *
     * Set `Negated` to `True` if you want AWS WAF to allow or block a request based on the negation of the settings in the ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example, if an `IPSet` includes the IP address `192.0.2.44`, AWS WAF will allow, block, or count requests based on all IP addresses *except*`192.0.2.44`.
     */
    public val negated: kotlin.Boolean = requireNotNull(builder.negated) { "A non-null value must be provided for negated" }
    /**
     * The type of predicate in a `Rule`, such as `ByteMatch` or `IPSet`.
     */
    public val type: aws.sdk.kotlin.services.wafregional.model.PredicateType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.Predicate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Predicate(")
        append("dataId=$dataId,")
        append("negated=$negated,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataId.hashCode()
        result = 31 * result + (negated.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Predicate

        if (dataId != other.dataId) return false
        if (negated != other.negated) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.Predicate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for a predicate in a `Rule`, such as `ByteMatchSetId` or `IPSetId`. The ID is returned by the corresponding `Create` or `List` command.
         */
        public var dataId: kotlin.String? = null
        /**
         * Set `Negated` to `False` if you want AWS WAF to allow, block, or count requests based on the settings in the specified ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example, if an `IPSet` includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
         *
         * Set `Negated` to `True` if you want AWS WAF to allow or block a request based on the negation of the settings in the ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example, if an `IPSet` includes the IP address `192.0.2.44`, AWS WAF will allow, block, or count requests based on all IP addresses *except*`192.0.2.44`.
         */
        public var negated: kotlin.Boolean? = null
        /**
         * The type of predicate in a `Rule`, such as `ByteMatch` or `IPSet`.
         */
        public var type: aws.sdk.kotlin.services.wafregional.model.PredicateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.Predicate) : this() {
            this.dataId = x.dataId
            this.negated = x.negated
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.Predicate = Predicate(this)

        internal fun correctErrors(): Builder {
            if (dataId == null) dataId = ""
            if (negated == null) negated = false
            if (type == null) type = PredicateType.SdkUnknown("no value provided")
            return this
        }
    }
}
