// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * In an UpdateByteMatchSet request, `ByteMatchSetUpdate` specifies whether to insert or delete a ByteMatchTuple and includes the settings for the `ByteMatchTuple`.
 */
public class ByteMatchSetUpdate private constructor(builder: Builder) {
    /**
     * Specifies whether to insert or delete a ByteMatchTuple.
     */
    public val action: aws.sdk.kotlin.services.wafregional.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify `DELETE` for the value of `Action`, the `ByteMatchTuple` values must exactly match the values in the `ByteMatchTuple` that you want to delete from the `ByteMatchSet`.
     */
    public val byteMatchTuple: aws.sdk.kotlin.services.wafregional.model.ByteMatchTuple? = builder.byteMatchTuple

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.ByteMatchSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByteMatchSetUpdate(")
        append("action=$action,")
        append("byteMatchTuple=$byteMatchTuple")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (byteMatchTuple?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByteMatchSetUpdate

        if (action != other.action) return false
        if (byteMatchTuple != other.byteMatchTuple) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.ByteMatchSetUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to insert or delete a ByteMatchTuple.
         */
        public var action: aws.sdk.kotlin.services.wafregional.model.ChangeAction? = null
        /**
         * Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify `DELETE` for the value of `Action`, the `ByteMatchTuple` values must exactly match the values in the `ByteMatchTuple` that you want to delete from the `ByteMatchSet`.
         */
        public var byteMatchTuple: aws.sdk.kotlin.services.wafregional.model.ByteMatchTuple? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.ByteMatchSetUpdate) : this() {
            this.action = x.action
            this.byteMatchTuple = x.byteMatchTuple
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.ByteMatchSetUpdate = ByteMatchSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.ByteMatchTuple] inside the given [block]
         */
        public fun byteMatchTuple(block: aws.sdk.kotlin.services.wafregional.model.ByteMatchTuple.Builder.() -> kotlin.Unit) {
            this.byteMatchTuple = aws.sdk.kotlin.services.wafregional.model.ByteMatchTuple.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
