// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * In a GetByteMatchSet request, `ByteMatchSet` is a complex type that contains the `ByteMatchSetId` and `Name` of a `ByteMatchSet`, and the values that you specified when you updated the `ByteMatchSet`.
 *
 * A complex type that contains `ByteMatchTuple` objects, which specify the parts of web requests that you want AWS WAF to inspect and the values that you want AWS WAF to search for. If a `ByteMatchSet` contains more than one `ByteMatchTuple` object, a request needs to match the settings in only one `ByteMatchTuple` to be considered a match.
 */
public class ByteMatchSet private constructor(builder: Builder) {
    /**
     * The `ByteMatchSetId` for a `ByteMatchSet`. You use `ByteMatchSetId` to get information about a `ByteMatchSet` (see GetByteMatchSet), update a `ByteMatchSet` (see UpdateByteMatchSet), insert a `ByteMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `ByteMatchSet` from AWS WAF (see DeleteByteMatchSet).
     *
     * `ByteMatchSetId` is returned by CreateByteMatchSet and by ListByteMatchSets.
     */
    public val byteMatchSetId: kotlin.String = requireNotNull(builder.byteMatchSetId) { "A non-null value must be provided for byteMatchSetId" }
    /**
     * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     */
    public val byteMatchTuples: List<ByteMatchTuple> = requireNotNull(builder.byteMatchTuples) { "A non-null value must be provided for byteMatchTuples" }
    /**
     * A friendly name or description of the ByteMatchSet. You can't change `Name` after you create a `ByteMatchSet`.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.ByteMatchSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByteMatchSet(")
        append("byteMatchSetId=$byteMatchSetId,")
        append("byteMatchTuples=$byteMatchTuples,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = byteMatchSetId.hashCode()
        result = 31 * result + (byteMatchTuples.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByteMatchSet

        if (byteMatchSetId != other.byteMatchSetId) return false
        if (byteMatchTuples != other.byteMatchTuples) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.ByteMatchSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `ByteMatchSetId` for a `ByteMatchSet`. You use `ByteMatchSetId` to get information about a `ByteMatchSet` (see GetByteMatchSet), update a `ByteMatchSet` (see UpdateByteMatchSet), insert a `ByteMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `ByteMatchSet` from AWS WAF (see DeleteByteMatchSet).
         *
         * `ByteMatchSetId` is returned by CreateByteMatchSet and by ListByteMatchSets.
         */
        public var byteMatchSetId: kotlin.String? = null
        /**
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         */
        public var byteMatchTuples: List<ByteMatchTuple>? = null
        /**
         * A friendly name or description of the ByteMatchSet. You can't change `Name` after you create a `ByteMatchSet`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.ByteMatchSet) : this() {
            this.byteMatchSetId = x.byteMatchSetId
            this.byteMatchTuples = x.byteMatchTuples
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.ByteMatchSet = ByteMatchSet(this)

        internal fun correctErrors(): Builder {
            if (byteMatchSetId == null) byteMatchSetId = ""
            if (byteMatchTuples == null) byteMatchTuples = emptyList()
            return this
        }
    }
}
