// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.serde

import aws.sdk.kotlin.services.wafregional.model.CreateWebAclMigrationStackResponse
import aws.sdk.kotlin.services.wafregional.model.WafRegionalException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateWebACLMigrationStackOperationDeserializer: HttpDeserialize<CreateWebAclMigrationStackResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateWebAclMigrationStackResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateWebAclMigrationStackError(context, call)
        }
        val builder = CreateWebAclMigrationStackResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWebACLMigrationStackOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateWebAclMigrationStackError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WafRegionalException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFEntityMigrationException" -> WafEntityMigrationExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WafRegionalException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWebACLMigrationStackOperationBody(builder: CreateWebAclMigrationStackResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val S3OBJECTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3ObjectUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(S3OBJECTURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                S3OBJECTURL_DESCRIPTOR.index -> builder.s3ObjectUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
