// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.serde

import aws.sdk.kotlin.services.wafregional.model.CreateRuleGroupResponse
import aws.sdk.kotlin.services.wafregional.model.RuleGroup
import aws.sdk.kotlin.services.wafregional.model.WafRegionalException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRuleGroupOperationDeserializer: HttpDeserialize<CreateRuleGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateRuleGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRuleGroupError(context, call)
        }
        val builder = CreateRuleGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateRuleGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateRuleGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WafRegionalException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFBadRequestException" -> WafBadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFDisallowedNameException" -> WafDisallowedNameExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFStaleDataException" -> WafStaleDataExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFTagOperationException" -> WafTagOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "WAFTagOperationInternalErrorException" -> WafTagOperationInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WafRegionalException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRuleGroupOperationBody(builder: CreateRuleGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeToken"))
    val RULEGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGETOKEN_DESCRIPTOR)
        field(RULEGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGETOKEN_DESCRIPTOR.index -> builder.changeToken = deserializeString()
                RULEGROUP_DESCRIPTOR.index -> builder.ruleGroup = deserializeRuleGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
