// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The `Id` and `Name` of an `XssMatchSet`.
 */
public class XssMatchSetSummary private constructor(builder: Builder) {
    /**
     * The name of the `XssMatchSet`, if any, specified by `Id`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for an `XssMatchSet`. You use `XssMatchSetId` to get information about a `XssMatchSet` (see GetXssMatchSet), update an `XssMatchSet` (see UpdateXssMatchSet), insert an `XssMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `XssMatchSet` from AWS WAF (see DeleteXssMatchSet).
     *
     * `XssMatchSetId` is returned by CreateXssMatchSet and by ListXssMatchSets.
     */
    public val xssMatchSetId: kotlin.String? = builder.xssMatchSetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.XssMatchSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XssMatchSetSummary(")
        append("name=$name,")
        append("xssMatchSetId=$xssMatchSetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (xssMatchSetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XssMatchSetSummary

        if (name != other.name) return false
        if (xssMatchSetId != other.xssMatchSetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.XssMatchSetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the `XssMatchSet`, if any, specified by `Id`.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for an `XssMatchSet`. You use `XssMatchSetId` to get information about a `XssMatchSet` (see GetXssMatchSet), update an `XssMatchSet` (see UpdateXssMatchSet), insert an `XssMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `XssMatchSet` from AWS WAF (see DeleteXssMatchSet).
         *
         * `XssMatchSetId` is returned by CreateXssMatchSet and by ListXssMatchSets.
         */
        public var xssMatchSetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.XssMatchSetSummary) : this() {
            this.name = x.name
            this.xssMatchSetId = x.xssMatchSetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.XssMatchSetSummary = XssMatchSetSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (xssMatchSetId == null) xssMatchSetId = ""
            return this
        }
    }
}
