// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
 */
public class SqlInjectionMatchTuple private constructor(builder: Builder) {
    /**
     * Specifies where in a web request to look for snippets of malicious SQL code.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafregional.model.FieldToMatch? = builder.fieldToMatch
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on `FieldToMatch` before inspecting it for a match.
     *
     * You can only specify a single type of TextTransformation.
     *
     * **CMD_LINE**
     *
     * When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:
     * + Delete the following characters: \ " ' ^
     * + Delete spaces before the following characters: / (
     * + Replace the following characters with a space: , ;
     * + Replace multiple spaces with one space
     * + Convert uppercase letters (A-Z) to lowercase (a-z)
     *
     * **COMPRESS_WHITE_SPACE**
     *
     * Use this option to replace the following characters with a space character (decimal 32):
     * + \f, formfeed, decimal 12
     * + \t, tab, decimal 9
     * + \n, newline, decimal 10
     * + \r, carriage return, decimal 13
     * + \v, vertical tab, decimal 11
     * + non-breaking space, decimal 160
     *
     * `COMPRESS_WHITE_SPACE` also replaces multiple spaces with one space.
     *
     * **HTML_ENTITY_DECODE**
     *
     * Use this option to replace HTML-encoded characters with unencoded characters. `HTML_ENTITY_DECODE` performs the following operations:
     * + Replaces `(ampersand)quot;` with `"`
     * + Replaces `(ampersand)nbsp;` with a non-breaking space, decimal 160
     * + Replaces `(ampersand)lt;` with a "less than" symbol
     * + Replaces `(ampersand)gt;` with `>`
     * + Replaces characters that are represented in hexadecimal format, `(ampersand)#xhhhh;`, with the corresponding characters
     * + Replaces characters that are represented in decimal format, `(ampersand)#nnnn;`, with the corresponding characters
     *
     * **LOWERCASE**
     *
     * Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
     *
     * **URL_DECODE**
     *
     * Use this option to decode a URL-encoded value.
     *
     * **NONE**
     *
     * Specify `NONE` if you don't want to perform any text transformations.
     */
    public val textTransformation: aws.sdk.kotlin.services.wafregional.model.TextTransformation? = builder.textTransformation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqlInjectionMatchTuple(")
        append("fieldToMatch=$fieldToMatch,")
        append("textTransformation=$textTransformation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (textTransformation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqlInjectionMatchTuple

        if (fieldToMatch != other.fieldToMatch) return false
        if (textTransformation != other.textTransformation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies where in a web request to look for snippets of malicious SQL code.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafregional.model.FieldToMatch? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on `FieldToMatch` before inspecting it for a match.
         *
         * You can only specify a single type of TextTransformation.
         *
         * **CMD_LINE**
         *
         * When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:
         * + Delete the following characters: \ " ' ^
         * + Delete spaces before the following characters: / (
         * + Replace the following characters with a space: , ;
         * + Replace multiple spaces with one space
         * + Convert uppercase letters (A-Z) to lowercase (a-z)
         *
         * **COMPRESS_WHITE_SPACE**
         *
         * Use this option to replace the following characters with a space character (decimal 32):
         * + \f, formfeed, decimal 12
         * + \t, tab, decimal 9
         * + \n, newline, decimal 10
         * + \r, carriage return, decimal 13
         * + \v, vertical tab, decimal 11
         * + non-breaking space, decimal 160
         *
         * `COMPRESS_WHITE_SPACE` also replaces multiple spaces with one space.
         *
         * **HTML_ENTITY_DECODE**
         *
         * Use this option to replace HTML-encoded characters with unencoded characters. `HTML_ENTITY_DECODE` performs the following operations:
         * + Replaces `(ampersand)quot;` with `"`
         * + Replaces `(ampersand)nbsp;` with a non-breaking space, decimal 160
         * + Replaces `(ampersand)lt;` with a "less than" symbol
         * + Replaces `(ampersand)gt;` with `>`
         * + Replaces characters that are represented in hexadecimal format, `(ampersand)#xhhhh;`, with the corresponding characters
         * + Replaces characters that are represented in decimal format, `(ampersand)#nnnn;`, with the corresponding characters
         *
         * **LOWERCASE**
         *
         * Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
         *
         * **URL_DECODE**
         *
         * Use this option to decode a URL-encoded value.
         *
         * **NONE**
         *
         * Specify `NONE` if you don't want to perform any text transformations.
         */
        public var textTransformation: aws.sdk.kotlin.services.wafregional.model.TextTransformation? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.textTransformation = x.textTransformation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.SqlInjectionMatchTuple = SqlInjectionMatchTuple(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafregional.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafregional.model.FieldToMatch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (fieldToMatch == null) fieldToMatch = FieldToMatch.Builder().correctErrors().build()
            if (textTransformation == null) textTransformation = TextTransformation.SdkUnknown("no value provided")
            return this
        }
    }
}
