// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A complex type that contains `SizeConstraint` objects, which specify the parts of web requests that you want AWS WAF to inspect the size of. If a `SizeConstraintSet` contains more than one `SizeConstraint` object, a request only needs to match one constraint to be considered a match.
 */
public class SizeConstraintSet private constructor(builder: Builder) {
    /**
     * The name, if any, of the `SizeConstraintSet`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for a `SizeConstraintSet`. You use `SizeConstraintSetId` to get information about a `SizeConstraintSet` (see GetSizeConstraintSet), update a `SizeConstraintSet` (see UpdateSizeConstraintSet), insert a `SizeConstraintSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SizeConstraintSet` from AWS WAF (see DeleteSizeConstraintSet).
     *
     * `SizeConstraintSetId` is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
     */
    public val sizeConstraintSetId: kotlin.String? = builder.sizeConstraintSetId
    /**
     * Specifies the parts of web requests that you want to inspect the size of.
     */
    public val sizeConstraints: List<SizeConstraint>? = builder.sizeConstraints

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SizeConstraintSet(")
        append("name=$name,")
        append("sizeConstraintSetId=$sizeConstraintSetId,")
        append("sizeConstraints=$sizeConstraints")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (sizeConstraintSetId?.hashCode() ?: 0)
        result = 31 * result + (sizeConstraints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SizeConstraintSet

        if (name != other.name) return false
        if (sizeConstraintSetId != other.sizeConstraintSetId) return false
        if (sizeConstraints != other.sizeConstraints) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name, if any, of the `SizeConstraintSet`.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `SizeConstraintSet`. You use `SizeConstraintSetId` to get information about a `SizeConstraintSet` (see GetSizeConstraintSet), update a `SizeConstraintSet` (see UpdateSizeConstraintSet), insert a `SizeConstraintSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SizeConstraintSet` from AWS WAF (see DeleteSizeConstraintSet).
         *
         * `SizeConstraintSetId` is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
         */
        public var sizeConstraintSetId: kotlin.String? = null
        /**
         * Specifies the parts of web requests that you want to inspect the size of.
         */
        public var sizeConstraints: List<SizeConstraint>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.SizeConstraintSet) : this() {
            this.name = x.name
            this.sizeConstraintSetId = x.sizeConstraintSetId
            this.sizeConstraints = x.sizeConstraints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.SizeConstraintSet = SizeConstraintSet(this)

        internal fun correctErrors(): Builder {
            if (sizeConstraintSetId == null) sizeConstraintSetId = ""
            if (sizeConstraints == null) sizeConstraints = emptyList()
            return this
        }
    }
}
