// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A combination of ByteMatchSet, IPSet, and/or SqlInjectionMatchSet objects that identify the web requests that you want to allow, block, or count. For example, you might create a `Rule` that includes the following predicates:
 * + An `IPSet` that causes AWS WAF to search for web requests that originate from the IP address `192.0.2.44`
 * + A `ByteMatchSet` that causes AWS WAF to search for web requests for which the value of the `User-Agent` header is `BadBot`.
 *
 * To match the settings in this `Rule`, a request must originate from `192.0.2.44` AND include a `User-Agent` header for which the value is `BadBot`.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * A friendly name or description for the metrics for this `Rule`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change `MetricName` after you create the `Rule`.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The friendly name or description for the `Rule`. You can't change the name of a `Rule` after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `Predicates` object contains one `Predicate` element for each ByteMatchSet, IPSet, or SqlInjectionMatchSet object that you want to include in a `Rule`.
     */
    public val predicates: List<Predicate>? = builder.predicates
    /**
     * A unique identifier for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete a one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
     *
     * `RuleId` is returned by CreateRule and by ListRules.
     */
    public val ruleId: kotlin.String? = builder.ruleId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("metricName=$metricName,")
        append("name=$name,")
        append("predicates=$predicates,")
        append("ruleId=$ruleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricName?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (predicates?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (predicates != other.predicates) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.Rule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A friendly name or description for the metrics for this `Rule`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change `MetricName` after you create the `Rule`.
         */
        public var metricName: kotlin.String? = null
        /**
         * The friendly name or description for the `Rule`. You can't change the name of a `Rule` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The `Predicates` object contains one `Predicate` element for each ByteMatchSet, IPSet, or SqlInjectionMatchSet object that you want to include in a `Rule`.
         */
        public var predicates: List<Predicate>? = null
        /**
         * A unique identifier for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete a one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
         *
         * `RuleId` is returned by CreateRule and by ListRules.
         */
        public var ruleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.Rule) : this() {
            this.metricName = x.metricName
            this.name = x.name
            this.predicates = x.predicates
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.Rule = Rule(this)

        internal fun correctErrors(): Builder {
            if (predicates == null) predicates = emptyList()
            if (ruleId == null) ruleId = ""
            return this
        }
    }
}
