// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A `RateBasedRule` is identical to a regular Rule, with one addition: a `RateBasedRule` counts the number of requests that arrive from a specified IP address every five minutes. For example, based on recent requests that you've seen from an attacker, you might create a `RateBasedRule` that includes the following conditions:
 * + The requests come from 192.0.2.44.
 * + They contain the value `BadBot` in the `User-Agent` header.
 *
 * In the rule, you also define the rate limit as 1,000.
 *
 * Requests that meet both of these conditions and exceed 1,000 requests every five minutes trigger the rule's action (block or count), which is defined in the web ACL.
 */
public class RateBasedRule private constructor(builder: Builder) {
    /**
     * The `Predicates` object contains one `Predicate` element for each ByteMatchSet, IPSet, or SqlInjectionMatchSet object that you want to include in a `RateBasedRule`.
     */
    public val matchPredicates: List<Predicate>? = builder.matchPredicates
    /**
     * A friendly name or description for the metrics for a `RateBasedRule`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the `RateBasedRule`.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * A friendly name or description for a `RateBasedRule`. You can't change the name of a `RateBasedRule` after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for `RateKey` is `IP`. `IP` indicates that requests arriving from the same IP address are subject to the `RateLimit` that is specified in the `RateBasedRule`.
     */
    public val rateKey: aws.sdk.kotlin.services.wafregional.model.RateKey? = builder.rateKey
    /**
     * The maximum number of requests, which have an identical value in the field specified by the `RateKey`, allowed in a five-minute period. If the number of requests exceeds the `RateLimit` and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
     */
    public val rateLimit: kotlin.Long = builder.rateLimit
    /**
     * A unique identifier for a `RateBasedRule`. You use `RuleId` to get more information about a `RateBasedRule` (see GetRateBasedRule), update a `RateBasedRule` (see UpdateRateBasedRule), insert a `RateBasedRule` into a `WebACL` or delete one from a `WebACL` (see UpdateWebACL), or delete a `RateBasedRule` from AWS WAF (see DeleteRateBasedRule).
     */
    public val ruleId: kotlin.String? = builder.ruleId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.RateBasedRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateBasedRule(")
        append("matchPredicates=$matchPredicates,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("rateKey=$rateKey,")
        append("rateLimit=$rateLimit,")
        append("ruleId=$ruleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchPredicates?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rateKey?.hashCode() ?: 0)
        result = 31 * result + (rateLimit.hashCode())
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RateBasedRule

        if (matchPredicates != other.matchPredicates) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (rateKey != other.rateKey) return false
        if (rateLimit != other.rateLimit) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.RateBasedRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `Predicates` object contains one `Predicate` element for each ByteMatchSet, IPSet, or SqlInjectionMatchSet object that you want to include in a `RateBasedRule`.
         */
        public var matchPredicates: List<Predicate>? = null
        /**
         * A friendly name or description for the metrics for a `RateBasedRule`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the `RateBasedRule`.
         */
        public var metricName: kotlin.String? = null
        /**
         * A friendly name or description for a `RateBasedRule`. You can't change the name of a `RateBasedRule` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for `RateKey` is `IP`. `IP` indicates that requests arriving from the same IP address are subject to the `RateLimit` that is specified in the `RateBasedRule`.
         */
        public var rateKey: aws.sdk.kotlin.services.wafregional.model.RateKey? = null
        /**
         * The maximum number of requests, which have an identical value in the field specified by the `RateKey`, allowed in a five-minute period. If the number of requests exceeds the `RateLimit` and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
         */
        public var rateLimit: kotlin.Long = 0L
        /**
         * A unique identifier for a `RateBasedRule`. You use `RuleId` to get more information about a `RateBasedRule` (see GetRateBasedRule), update a `RateBasedRule` (see UpdateRateBasedRule), insert a `RateBasedRule` into a `WebACL` or delete one from a `WebACL` (see UpdateWebACL), or delete a `RateBasedRule` from AWS WAF (see DeleteRateBasedRule).
         */
        public var ruleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.RateBasedRule) : this() {
            this.matchPredicates = x.matchPredicates
            this.metricName = x.metricName
            this.name = x.name
            this.rateKey = x.rateKey
            this.rateLimit = x.rateLimit
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.RateBasedRule = RateBasedRule(this)

        internal fun correctErrors(): Builder {
            if (matchPredicates == null) matchPredicates = emptyList()
            if (rateKey == null) rateKey = RateKey.SdkUnknown("no value provided")
            if (rateLimit == null) rateLimit = 0L
            if (ruleId == null) ruleId = ""
            return this
        }
    }
}
