// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The Amazon Kinesis Data Firehose, `RedactedFields` information, and the web ACL Amazon Resource Name (ARN).
 */
public class LoggingConfiguration private constructor(builder: Builder) {
    /**
     * An array of Amazon Kinesis Data Firehose ARNs.
     */
    public val logDestinationConfigs: List<String>? = builder.logDestinationConfigs
    /**
     * The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be `xxx`.
     */
    public val redactedFields: List<FieldToMatch>? = builder.redactedFields
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs`.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.LoggingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfiguration(")
        append("logDestinationConfigs=$logDestinationConfigs,")
        append("redactedFields=$redactedFields,")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDestinationConfigs?.hashCode() ?: 0
        result = 31 * result + (redactedFields?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfiguration

        if (logDestinationConfigs != other.logDestinationConfigs) return false
        if (redactedFields != other.redactedFields) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.LoggingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of Amazon Kinesis Data Firehose ARNs.
         */
        public var logDestinationConfigs: List<String>? = null
        /**
         * The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be `xxx`.
         */
        public var redactedFields: List<FieldToMatch>? = null
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs`.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.LoggingConfiguration) : this() {
            this.logDestinationConfigs = x.logDestinationConfigs
            this.redactedFields = x.redactedFields
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.LoggingConfiguration = LoggingConfiguration(this)

        internal fun correctErrors(): Builder {
            if (logDestinationConfigs == null) logDestinationConfigs = emptyList()
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
