// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The country from which web requests originate that you want AWS WAF to search for.
 */
public class GeoMatchConstraint private constructor(builder: Builder) {
    /**
     * The type of geographical area you want AWS WAF to search for. Currently `Country` is the only valid value.
     */
    public val type: aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraintType? = builder.type
    /**
     * The country that you want AWS WAF to search for.
     */
    public val value: aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraintValue? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoMatchConstraint(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoMatchConstraint

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of geographical area you want AWS WAF to search for. Currently `Country` is the only valid value.
         */
        public var type: aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraintType? = null
        /**
         * The country that you want AWS WAF to search for.
         */
        public var value: aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraintValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraint) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.GeoMatchConstraint = GeoMatchConstraint(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = GeoMatchConstraintType.SdkUnknown("no value provided")
            if (value == null) value = GeoMatchConstraintValue.SdkUnknown("no value provided")
            return this
        }
    }
}
