// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies where in a web request to look for `TargetString`.
 */
public class FieldToMatch private constructor(builder: Builder) {
    /**
     * When the value of `Type` is `HEADER`, enter the name of the header that you want AWS WAF to search, for example, `User-Agent` or `Referer`. The name of the header is not case sensitive.
     *
     * When the value of `Type` is `SINGLE_QUERY_ARG`, enter the name of the parameter that you want AWS WAF to search, for example, `UserName` or `SalesRegion`. The parameter name is not case sensitive.
     *
     * If the value of `Type` is any other value, omit `Data`.
     */
    public val data: kotlin.String? = builder.data
    /**
     * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:
     * + `HEADER`: A specified request header, for example, the value of the `User-Agent` or `Referer` header. If you choose `HEADER` for the type, specify the name of the header in `Data`.
     * + `METHOD`: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
     * + `QUERY_STRING`: A query string, which is the part of a URL that appears after a `?` character, if any.
     * + `URI`: The part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     * + `BODY`: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first `8192` bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see CreateSizeConstraintSet.
     * + `SINGLE_QUERY_ARG`: The parameter in the query string that you will inspect, such as *UserName* or *SalesRegion*. The maximum length for `SINGLE_QUERY_ARG` is 30 characters.
     * + `ALL_QUERY_ARGS`: Similar to `SINGLE_QUERY_ARG`, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in `TargetString`.
     */
    public val type: aws.sdk.kotlin.services.wafregional.model.MatchFieldType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.FieldToMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldToMatch(")
        append("data=$data,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FieldToMatch

        if (data != other.data) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.FieldToMatch = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When the value of `Type` is `HEADER`, enter the name of the header that you want AWS WAF to search, for example, `User-Agent` or `Referer`. The name of the header is not case sensitive.
         *
         * When the value of `Type` is `SINGLE_QUERY_ARG`, enter the name of the parameter that you want AWS WAF to search, for example, `UserName` or `SalesRegion`. The parameter name is not case sensitive.
         *
         * If the value of `Type` is any other value, omit `Data`.
         */
        public var data: kotlin.String? = null
        /**
         * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:
         * + `HEADER`: A specified request header, for example, the value of the `User-Agent` or `Referer` header. If you choose `HEADER` for the type, specify the name of the header in `Data`.
         * + `METHOD`: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
         * + `QUERY_STRING`: A query string, which is the part of a URL that appears after a `?` character, if any.
         * + `URI`: The part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
         * + `BODY`: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first `8192` bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see CreateSizeConstraintSet.
         * + `SINGLE_QUERY_ARG`: The parameter in the query string that you will inspect, such as *UserName* or *SalesRegion*. The maximum length for `SINGLE_QUERY_ARG` is 30 characters.
         * + `ALL_QUERY_ARGS`: Similar to `SINGLE_QUERY_ARG`, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in `TargetString`.
         */
        public var type: aws.sdk.kotlin.services.wafregional.model.MatchFieldType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.FieldToMatch) : this() {
            this.data = x.data
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.FieldToMatch = FieldToMatch(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = MatchFieldType.SdkUnknown("no value provided")
            return this
        }
    }
}
