// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafregional.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The `ActivatedRule` object in an UpdateWebACL request specifies a `Rule` that you want to insert or delete, the priority of the `Rule` in the `WebACL`, and the action that you want AWS WAF to take when a web request matches the `Rule` (`ALLOW`, `BLOCK`, or `COUNT`).
 *
 * To specify whether to insert or delete a `Rule`, use the `Action` parameter in the WebACLUpdate data type.
 */
public class ActivatedRule private constructor(builder: Builder) {
    /**
     * Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the `Rule`. Valid values for `Action` include the following:
     * + `ALLOW`: CloudFront responds with the requested object.
     * + `BLOCK`: CloudFront responds with an HTTP 403 (Forbidden) status code.
     * + `COUNT`: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL.
     *
     * `ActivatedRule|OverrideAction` applies only when updating or adding a `RuleGroup` to a `WebACL`. In this case, you do not use `ActivatedRule|Action`. For all other update requests, `ActivatedRule|Action` is used instead of `ActivatedRule|OverrideAction`.
     */
    public val action: aws.sdk.kotlin.services.wafregional.model.WafAction? = builder.action
    /**
     * An array of rules to exclude from a rule group. This is applicable only when the `ActivatedRule` refers to a `RuleGroup`.
     *
     * Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.
     *
     * Specifying `ExcludedRules` does not remove those rules from the rule group. Rather, it changes the action for the rules to `COUNT`. Therefore, requests that match an `ExcludedRule` are counted but not blocked. The `RuleGroup` owner will receive COUNT metrics for each `ExcludedRule`.
     *
     * If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:
     * + Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see [Logging Web ACL Traffic Information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html).
     * + Submit an UpdateWebACL request that has two actions:
     *    + The first action deletes the existing rule group from the web ACL. That is, in the UpdateWebACL request, the first `Updates:Action` should be `DELETE` and `Updates:ActivatedRule:RuleId` should be the rule group that contains the rules that you want to exclude.
     *    + The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second `Updates:Action` should be `INSERT`, `Updates:ActivatedRule:RuleId` should be the rule group that you just removed, and `ExcludedRules` should contain the rules that you want to exclude.
     */
    public val excludedRules: List<ExcludedRule>? = builder.excludedRules
    /**
     * Use the `OverrideAction` to test your `RuleGroup`.
     *
     * Any rule in a `RuleGroup` can potentially block a request. If you set the `OverrideAction` to `None`, the `RuleGroup` will block a request if any individual rule in the `RuleGroup` matches the request and is configured to block that request. However if you first want to test the `RuleGroup`, set the `OverrideAction` to `Count`. The `RuleGroup` will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using GetSampledRequests.
     *
     * `ActivatedRule|OverrideAction` applies only when updating or adding a `RuleGroup` to a `WebACL`. In this case you do not use `ActivatedRule|Action`. For all other update requests, `ActivatedRule|Action` is used instead of `ActivatedRule|OverrideAction`.
     */
    public val overrideAction: aws.sdk.kotlin.services.wafregional.model.WafOverrideAction? = builder.overrideAction
    /**
     * Specifies the order in which the `Rules` in a `WebACL` are evaluated. Rules with a lower value for `Priority` are evaluated before `Rules` with a higher value. The value must be a unique integer. If you add multiple `Rules` to a `WebACL`, the values don't need to be consecutive.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The `RuleId` for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete a one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
     *
     * `RuleId` is returned by CreateRule and by ListRules.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The rule type, either `REGULAR`, as defined by Rule, `RATE_BASED`, as defined by RateBasedRule, or `GROUP`, as defined by RuleGroup. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the UpdateWebACL request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist.
     */
    public val type: aws.sdk.kotlin.services.wafregional.model.WafRuleType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafregional.model.ActivatedRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivatedRule(")
        append("action=$action,")
        append("excludedRules=$excludedRules,")
        append("overrideAction=$overrideAction,")
        append("priority=$priority,")
        append("ruleId=$ruleId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (excludedRules?.hashCode() ?: 0)
        result = 31 * result + (overrideAction?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivatedRule

        if (action != other.action) return false
        if (excludedRules != other.excludedRules) return false
        if (overrideAction != other.overrideAction) return false
        if (priority != other.priority) return false
        if (ruleId != other.ruleId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafregional.model.ActivatedRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the `Rule`. Valid values for `Action` include the following:
         * + `ALLOW`: CloudFront responds with the requested object.
         * + `BLOCK`: CloudFront responds with an HTTP 403 (Forbidden) status code.
         * + `COUNT`: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL.
         *
         * `ActivatedRule|OverrideAction` applies only when updating or adding a `RuleGroup` to a `WebACL`. In this case, you do not use `ActivatedRule|Action`. For all other update requests, `ActivatedRule|Action` is used instead of `ActivatedRule|OverrideAction`.
         */
        public var action: aws.sdk.kotlin.services.wafregional.model.WafAction? = null
        /**
         * An array of rules to exclude from a rule group. This is applicable only when the `ActivatedRule` refers to a `RuleGroup`.
         *
         * Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.
         *
         * Specifying `ExcludedRules` does not remove those rules from the rule group. Rather, it changes the action for the rules to `COUNT`. Therefore, requests that match an `ExcludedRule` are counted but not blocked. The `RuleGroup` owner will receive COUNT metrics for each `ExcludedRule`.
         *
         * If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:
         * + Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see [Logging Web ACL Traffic Information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html).
         * + Submit an UpdateWebACL request that has two actions:
         *    + The first action deletes the existing rule group from the web ACL. That is, in the UpdateWebACL request, the first `Updates:Action` should be `DELETE` and `Updates:ActivatedRule:RuleId` should be the rule group that contains the rules that you want to exclude.
         *    + The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second `Updates:Action` should be `INSERT`, `Updates:ActivatedRule:RuleId` should be the rule group that you just removed, and `ExcludedRules` should contain the rules that you want to exclude.
         */
        public var excludedRules: List<ExcludedRule>? = null
        /**
         * Use the `OverrideAction` to test your `RuleGroup`.
         *
         * Any rule in a `RuleGroup` can potentially block a request. If you set the `OverrideAction` to `None`, the `RuleGroup` will block a request if any individual rule in the `RuleGroup` matches the request and is configured to block that request. However if you first want to test the `RuleGroup`, set the `OverrideAction` to `Count`. The `RuleGroup` will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using GetSampledRequests.
         *
         * `ActivatedRule|OverrideAction` applies only when updating or adding a `RuleGroup` to a `WebACL`. In this case you do not use `ActivatedRule|Action`. For all other update requests, `ActivatedRule|Action` is used instead of `ActivatedRule|OverrideAction`.
         */
        public var overrideAction: aws.sdk.kotlin.services.wafregional.model.WafOverrideAction? = null
        /**
         * Specifies the order in which the `Rules` in a `WebACL` are evaluated. Rules with a lower value for `Priority` are evaluated before `Rules` with a higher value. The value must be a unique integer. If you add multiple `Rules` to a `WebACL`, the values don't need to be consecutive.
         */
        public var priority: kotlin.Int? = null
        /**
         * The `RuleId` for a `Rule`. You use `RuleId` to get more information about a `Rule` (see GetRule), update a `Rule` (see UpdateRule), insert a `Rule` into a `WebACL` or delete a one from a `WebACL` (see UpdateWebACL), or delete a `Rule` from AWS WAF (see DeleteRule).
         *
         * `RuleId` is returned by CreateRule and by ListRules.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The rule type, either `REGULAR`, as defined by Rule, `RATE_BASED`, as defined by RateBasedRule, or `GROUP`, as defined by RuleGroup. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the UpdateWebACL request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist.
         */
        public var type: aws.sdk.kotlin.services.wafregional.model.WafRuleType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafregional.model.ActivatedRule) : this() {
            this.action = x.action
            this.excludedRules = x.excludedRules
            this.overrideAction = x.overrideAction
            this.priority = x.priority
            this.ruleId = x.ruleId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafregional.model.ActivatedRule = ActivatedRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.WafAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.wafregional.model.WafAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.wafregional.model.WafAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafregional.model.WafOverrideAction] inside the given [block]
         */
        public fun overrideAction(block: aws.sdk.kotlin.services.wafregional.model.WafOverrideAction.Builder.() -> kotlin.Unit) {
            this.overrideAction = aws.sdk.kotlin.services.wafregional.model.WafOverrideAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (priority == null) priority = 0
            if (ruleId == null) ruleId = ""
            return this
        }
    }
}
