// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.serde

import aws.sdk.kotlin.services.waf.model.ListXssMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.WafException
import aws.sdk.kotlin.services.waf.model.XssMatchSetSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListXssMatchSetsOperationDeserializer: HttpDeserializer.NonStreaming<ListXssMatchSetsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListXssMatchSetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListXssMatchSetsError(context, call, payload)
        }
        val builder = ListXssMatchSetsResponse.Builder()

        if (payload != null) {
            deserializeListXssMatchSetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListXssMatchSetsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInvalidAccountException" -> WafInvalidAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListXssMatchSetsOperationBody(builder: ListXssMatchSetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val XSSMATCHSETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("XssMatchSets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTMARKER_DESCRIPTOR)
        field(XSSMATCHSETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                XSSMATCHSETS_DESCRIPTOR.index -> builder.xssMatchSets =
                    deserializer.deserializeList(XSSMATCHSETS_DESCRIPTOR) {
                        val col0 = mutableListOf<XssMatchSetSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeXssMatchSetSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
