// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The `Id` and `Name` of a `SqlInjectionMatchSet`.
 */
public class SqlInjectionMatchSetSummary private constructor(builder: Builder) {
    /**
     * The name of the `SqlInjectionMatchSet`, if any, specified by `Id`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A unique identifier for a `SqlInjectionMatchSet`. You use `SqlInjectionMatchSetId` to get information about a `SqlInjectionMatchSet` (see GetSqlInjectionMatchSet), update a `SqlInjectionMatchSet` (see UpdateSqlInjectionMatchSet), insert a `SqlInjectionMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SqlInjectionMatchSet` from AWS WAF (see DeleteSqlInjectionMatchSet).
     *
     * `SqlInjectionMatchSetId` is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
     */
    public val sqlInjectionMatchSetId: kotlin.String = requireNotNull(builder.sqlInjectionMatchSetId) { "A non-null value must be provided for sqlInjectionMatchSetId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqlInjectionMatchSetSummary(")
        append("name=$name,")
        append("sqlInjectionMatchSetId=$sqlInjectionMatchSetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (sqlInjectionMatchSetId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqlInjectionMatchSetSummary

        if (name != other.name) return false
        if (sqlInjectionMatchSetId != other.sqlInjectionMatchSetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the `SqlInjectionMatchSet`, if any, specified by `Id`.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `SqlInjectionMatchSet`. You use `SqlInjectionMatchSetId` to get information about a `SqlInjectionMatchSet` (see GetSqlInjectionMatchSet), update a `SqlInjectionMatchSet` (see UpdateSqlInjectionMatchSet), insert a `SqlInjectionMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SqlInjectionMatchSet` from AWS WAF (see DeleteSqlInjectionMatchSet).
         *
         * `SqlInjectionMatchSetId` is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
         */
        public var sqlInjectionMatchSetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSetSummary) : this() {
            this.name = x.name
            this.sqlInjectionMatchSetId = x.sqlInjectionMatchSetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSetSummary = SqlInjectionMatchSetSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (sqlInjectionMatchSetId == null) sqlInjectionMatchSetId = ""
            return this
        }
    }
}
