// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetSampledRequestsRequest private constructor(builder: Builder) {
    /**
     * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of `MaxItems`, `GetSampledRequests` returns information about all of them.
     */
    public val maxItems: kotlin.Long? = builder.maxItems
    /**
     * `RuleId` is one of three values:
     * + The `RuleId` of the `Rule` or the `RuleGroupId` of the `RuleGroup` for which you want `GetSampledRequests` to return a sample of requests.
     * + `Default_Action`, which causes `GetSampledRequests` to return a sample of the requests that didn't match any of the rules in the specified `WebACL`.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The start date and time and the end date and time of the range for which you want `GetSampledRequests` to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, `Z`. For example, `"2016-09-27T14:50Z"`. You can specify any time range in the previous three hours.
     */
    public val timeWindow: aws.sdk.kotlin.services.waf.model.TimeWindow? = builder.timeWindow
    /**
     * The `WebACLId` of the `WebACL` for which you want `GetSampledRequests` to return a sample of requests.
     */
    public val webAclId: kotlin.String? = builder.webAclId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.GetSampledRequestsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSampledRequestsRequest(")
        append("maxItems=$maxItems,")
        append("ruleId=$ruleId,")
        append("timeWindow=$timeWindow,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxItems?.hashCode() ?: 0
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (timeWindow?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSampledRequestsRequest

        if (maxItems != other.maxItems) return false
        if (ruleId != other.ruleId) return false
        if (timeWindow != other.timeWindow) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.GetSampledRequestsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of `MaxItems`, `GetSampledRequests` returns information about all of them.
         */
        public var maxItems: kotlin.Long? = null
        /**
         * `RuleId` is one of three values:
         * + The `RuleId` of the `Rule` or the `RuleGroupId` of the `RuleGroup` for which you want `GetSampledRequests` to return a sample of requests.
         * + `Default_Action`, which causes `GetSampledRequests` to return a sample of the requests that didn't match any of the rules in the specified `WebACL`.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The start date and time and the end date and time of the range for which you want `GetSampledRequests` to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, `Z`. For example, `"2016-09-27T14:50Z"`. You can specify any time range in the previous three hours.
         */
        public var timeWindow: aws.sdk.kotlin.services.waf.model.TimeWindow? = null
        /**
         * The `WebACLId` of the `WebACL` for which you want `GetSampledRequests` to return a sample of requests.
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.GetSampledRequestsRequest) : this() {
            this.maxItems = x.maxItems
            this.ruleId = x.ruleId
            this.timeWindow = x.timeWindow
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.GetSampledRequestsRequest = GetSampledRequestsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.TimeWindow] inside the given [block]
         */
        public fun timeWindow(block: aws.sdk.kotlin.services.waf.model.TimeWindow.Builder.() -> kotlin.Unit) {
            this.timeWindow = aws.sdk.kotlin.services.waf.model.TimeWindow.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
