// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains one or more countries that AWS WAF will search for.
 */
public class GeoMatchSet private constructor(builder: Builder) {
    /**
     * An array of GeoMatchConstraint objects, which contain the country that you want AWS WAF to search for.
     */
    public val geoMatchConstraints: List<GeoMatchConstraint> = requireNotNull(builder.geoMatchConstraints) { "A non-null value must be provided for geoMatchConstraints" }
    /**
     * The `GeoMatchSetId` for an `GeoMatchSet`. You use `GeoMatchSetId` to get information about a `GeoMatchSet` (see GeoMatchSet), update a `GeoMatchSet` (see UpdateGeoMatchSet), insert a `GeoMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `GeoMatchSet` from AWS WAF (see DeleteGeoMatchSet).
     *
     * `GeoMatchSetId` is returned by CreateGeoMatchSet and by ListGeoMatchSets.
     */
    public val geoMatchSetId: kotlin.String = requireNotNull(builder.geoMatchSetId) { "A non-null value must be provided for geoMatchSetId" }
    /**
     * A friendly name or description of the GeoMatchSet. You can't change the name of an `GeoMatchSet` after you create it.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.GeoMatchSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoMatchSet(")
        append("geoMatchConstraints=$geoMatchConstraints,")
        append("geoMatchSetId=$geoMatchSetId,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = geoMatchConstraints.hashCode()
        result = 31 * result + (geoMatchSetId.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoMatchSet

        if (geoMatchConstraints != other.geoMatchConstraints) return false
        if (geoMatchSetId != other.geoMatchSetId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.GeoMatchSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of GeoMatchConstraint objects, which contain the country that you want AWS WAF to search for.
         */
        public var geoMatchConstraints: List<GeoMatchConstraint>? = null
        /**
         * The `GeoMatchSetId` for an `GeoMatchSet`. You use `GeoMatchSetId` to get information about a `GeoMatchSet` (see GeoMatchSet), update a `GeoMatchSet` (see UpdateGeoMatchSet), insert a `GeoMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `GeoMatchSet` from AWS WAF (see DeleteGeoMatchSet).
         *
         * `GeoMatchSetId` is returned by CreateGeoMatchSet and by ListGeoMatchSets.
         */
        public var geoMatchSetId: kotlin.String? = null
        /**
         * A friendly name or description of the GeoMatchSet. You can't change the name of an `GeoMatchSet` after you create it.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.GeoMatchSet) : this() {
            this.geoMatchConstraints = x.geoMatchConstraints
            this.geoMatchSetId = x.geoMatchSetId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.GeoMatchSet = GeoMatchSet(this)

        internal fun correctErrors(): Builder {
            if (geoMatchConstraints == null) geoMatchConstraints = emptyList()
            if (geoMatchSetId == null) geoMatchSetId = ""
            return this
        }
    }
}
