// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.serde

import aws.sdk.kotlin.services.waf.model.CreateRegexPatternSetResponse
import aws.sdk.kotlin.services.waf.model.RegexPatternSet
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRegexPatternSetOperationDeserializer: HttpDeserializer.NonStreaming<CreateRegexPatternSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRegexPatternSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRegexPatternSetError(context, call, payload)
        }
        val builder = CreateRegexPatternSetResponse.Builder()

        if (payload != null) {
            deserializeCreateRegexPatternSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRegexPatternSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFDisallowedNameException" -> WafDisallowedNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFStaleDataException" -> WafStaleDataExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRegexPatternSetOperationBody(builder: CreateRegexPatternSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeToken"))
    val REGEXPATTERNSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RegexPatternSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGETOKEN_DESCRIPTOR)
        field(REGEXPATTERNSET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGETOKEN_DESCRIPTOR.index -> builder.changeToken = deserializeString()
                REGEXPATTERNSET_DESCRIPTOR.index -> builder.regexPatternSet = deserializeRegexPatternSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
