// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A complex type that contains `XssMatchTuple` objects, which specify the parts of web requests that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header. If a `XssMatchSet` contains more than one `XssMatchTuple` object, a request needs to include cross-site scripting attacks in only one of the specified parts of the request to be considered a match.
 */
public class XssMatchSet private constructor(builder: Builder) {
    /**
     * The name, if any, of the `XssMatchSet`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for an `XssMatchSet`. You use `XssMatchSetId` to get information about an `XssMatchSet` (see GetXssMatchSet), update an `XssMatchSet` (see UpdateXssMatchSet), insert an `XssMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `XssMatchSet` from AWS WAF (see DeleteXssMatchSet).
     *
     * `XssMatchSetId` is returned by CreateXssMatchSet and by ListXssMatchSets.
     */
    public val xssMatchSetId: kotlin.String = requireNotNull(builder.xssMatchSetId) { "A non-null value must be provided for xssMatchSetId" }
    /**
     * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    public val xssMatchTuples: List<XssMatchTuple> = requireNotNull(builder.xssMatchTuples) { "A non-null value must be provided for xssMatchTuples" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.XssMatchSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XssMatchSet(")
        append("name=$name,")
        append("xssMatchSetId=$xssMatchSetId,")
        append("xssMatchTuples=$xssMatchTuples")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (xssMatchSetId.hashCode())
        result = 31 * result + (xssMatchTuples.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XssMatchSet

        if (name != other.name) return false
        if (xssMatchSetId != other.xssMatchSetId) return false
        if (xssMatchTuples != other.xssMatchTuples) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.XssMatchSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name, if any, of the `XssMatchSet`.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for an `XssMatchSet`. You use `XssMatchSetId` to get information about an `XssMatchSet` (see GetXssMatchSet), update an `XssMatchSet` (see UpdateXssMatchSet), insert an `XssMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `XssMatchSet` from AWS WAF (see DeleteXssMatchSet).
         *
         * `XssMatchSetId` is returned by CreateXssMatchSet and by ListXssMatchSets.
         */
        public var xssMatchSetId: kotlin.String? = null
        /**
         * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         */
        public var xssMatchTuples: List<XssMatchTuple>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.XssMatchSet) : this() {
            this.name = x.name
            this.xssMatchSetId = x.xssMatchSetId
            this.xssMatchTuples = x.xssMatchTuples
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.XssMatchSet = XssMatchSet(this)

        internal fun correctErrors(): Builder {
            if (xssMatchSetId == null) xssMatchSetId = ""
            if (xssMatchTuples == null) xssMatchTuples = emptyList()
            return this
        }
    }
}
