// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The operation failed due to a problem with the migration. The failure cause is provided in the exception, in the `MigrationErrorType`:
 * + `ENTITY_NOT_SUPPORTED` - The web ACL has an unsupported entity but the `IgnoreUnsupportedType` is not set to true.
 * + `ENTITY_NOT_FOUND` - The web ACL doesn't exist.
 * + `S3_BUCKET_NO_PERMISSION` - You don't have permission to perform the `PutObject` action to the specified Amazon S3 bucket.
 * + `S3_BUCKET_NOT_ACCESSIBLE` - The bucket policy doesn't allow AWS WAF to perform the `PutObject` action in the bucket.
 * + `S3_BUCKET_NOT_FOUND` - The S3 bucket doesn't exist.
 * + `S3_BUCKET_INVALID_REGION` - The S3 bucket is not in the same Region as the web ACL.
 * + `S3_INTERNAL_ERROR` - AWS WAF failed to create the template in the S3 bucket for another reason.
 */
public class WafEntityMigrationException private constructor(builder: Builder) : WafException(builder.message) {

    public val migrationErrorReason: kotlin.String? = builder.migrationErrorReason
    public val migrationErrorType: aws.sdk.kotlin.services.waf.model.MigrationErrorType? = builder.migrationErrorType

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.WafEntityMigrationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafEntityMigrationException(")
        append("message=$message,")
        append("migrationErrorReason=$migrationErrorReason,")
        append("migrationErrorType=$migrationErrorType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (migrationErrorReason?.hashCode() ?: 0)
        result = 31 * result + (migrationErrorType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafEntityMigrationException

        if (message != other.message) return false
        if (migrationErrorReason != other.migrationErrorReason) return false
        if (migrationErrorType != other.migrationErrorType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.WafEntityMigrationException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        public var migrationErrorReason: kotlin.String? = null
        public var migrationErrorType: aws.sdk.kotlin.services.waf.model.MigrationErrorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.WafEntityMigrationException) : this() {
            this.message = x.message
            this.migrationErrorReason = x.migrationErrorReason
            this.migrationErrorType = x.migrationErrorType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.WafEntityMigrationException = WafEntityMigrationException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
