// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * For the action that is associated with a rule in a `WebACL`, specifies the action that you want AWS WAF to perform when a web request matches all of the conditions in a rule. For the default action in a `WebACL`, specifies the action that you want AWS WAF to take when a web request doesn't match all of the conditions in any of the rules in a `WebACL`.
 */
public class WafAction private constructor(builder: Builder) {
    /**
     * Specifies how you want AWS WAF to respond to requests that match the settings in a `Rule`. Valid settings include the following:
     * + `ALLOW`: AWS WAF allows requests
     * + `BLOCK`: AWS WAF blocks requests
     * + `COUNT`: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify `COUNT` for the default action for a `WebACL`.
     */
    public val type: aws.sdk.kotlin.services.waf.model.WafActionType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.WafAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafAction(")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafAction

        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.WafAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies how you want AWS WAF to respond to requests that match the settings in a `Rule`. Valid settings include the following:
         * + `ALLOW`: AWS WAF allows requests
         * + `BLOCK`: AWS WAF blocks requests
         * + `COUNT`: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify `COUNT` for the default action for a `WebACL`.
         */
        public var type: aws.sdk.kotlin.services.waf.model.WafActionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.WafAction) : this() {
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.WafAction = WafAction(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = WafActionType.SdkUnknown("no value provided")
            return this
        }
    }
}
