// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A summary of the rule groups you are subscribed to.
 */
public class SubscribedRuleGroupSummary private constructor(builder: Builder) {
    /**
     * A friendly name or description for the metrics for this `RuleGroup`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the `RuleGroup`.
     */
    public val metricName: kotlin.String = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }
    /**
     * A friendly name or description of the `RuleGroup`. You can't change the name of a `RuleGroup` after you create it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A unique identifier for a `RuleGroup`.
     */
    public val ruleGroupId: kotlin.String = requireNotNull(builder.ruleGroupId) { "A non-null value must be provided for ruleGroupId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.SubscribedRuleGroupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscribedRuleGroupSummary(")
        append("metricName=$metricName,")
        append("name=$name,")
        append("ruleGroupId=$ruleGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricName.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (ruleGroupId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscribedRuleGroupSummary

        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (ruleGroupId != other.ruleGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.SubscribedRuleGroupSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description for the metrics for this `RuleGroup`. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the `RuleGroup`.
         */
        public var metricName: kotlin.String? = null
        /**
         * A friendly name or description of the `RuleGroup`. You can't change the name of a `RuleGroup` after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `RuleGroup`.
         */
        public var ruleGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.SubscribedRuleGroupSummary) : this() {
            this.metricName = x.metricName
            this.name = x.name
            this.ruleGroupId = x.ruleGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.SubscribedRuleGroupSummary = SubscribedRuleGroupSummary(this)

        internal fun correctErrors(): Builder {
            if (metricName == null) metricName = ""
            if (name == null) name = ""
            if (ruleGroupId == null) ruleGroupId = ""
            return this
        }
    }
}
