// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * A complex type that contains `SqlInjectionMatchTuple` objects, which specify the parts of web requests that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header. If a `SqlInjectionMatchSet` contains more than one `SqlInjectionMatchTuple` object, a request needs to include snippets of SQL code in only one of the specified parts of the request to be considered a match.
 */
public class SqlInjectionMatchSet private constructor(builder: Builder) {
    /**
     * The name, if any, of the `SqlInjectionMatchSet`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for a `SqlInjectionMatchSet`. You use `SqlInjectionMatchSetId` to get information about a `SqlInjectionMatchSet` (see GetSqlInjectionMatchSet), update a `SqlInjectionMatchSet` (see UpdateSqlInjectionMatchSet), insert a `SqlInjectionMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SqlInjectionMatchSet` from AWS WAF (see DeleteSqlInjectionMatchSet).
     *
     * `SqlInjectionMatchSetId` is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
     */
    public val sqlInjectionMatchSetId: kotlin.String = requireNotNull(builder.sqlInjectionMatchSetId) { "A non-null value must be provided for sqlInjectionMatchSetId" }
    /**
     * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
     */
    public val sqlInjectionMatchTuples: List<SqlInjectionMatchTuple> = requireNotNull(builder.sqlInjectionMatchTuples) { "A non-null value must be provided for sqlInjectionMatchTuples" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqlInjectionMatchSet(")
        append("name=$name,")
        append("sqlInjectionMatchSetId=$sqlInjectionMatchSetId,")
        append("sqlInjectionMatchTuples=$sqlInjectionMatchTuples")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (sqlInjectionMatchSetId.hashCode())
        result = 31 * result + (sqlInjectionMatchTuples.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqlInjectionMatchSet

        if (name != other.name) return false
        if (sqlInjectionMatchSetId != other.sqlInjectionMatchSetId) return false
        if (sqlInjectionMatchTuples != other.sqlInjectionMatchTuples) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name, if any, of the `SqlInjectionMatchSet`.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for a `SqlInjectionMatchSet`. You use `SqlInjectionMatchSetId` to get information about a `SqlInjectionMatchSet` (see GetSqlInjectionMatchSet), update a `SqlInjectionMatchSet` (see UpdateSqlInjectionMatchSet), insert a `SqlInjectionMatchSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete a `SqlInjectionMatchSet` from AWS WAF (see DeleteSqlInjectionMatchSet).
         *
         * `SqlInjectionMatchSetId` is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
         */
        public var sqlInjectionMatchSetId: kotlin.String? = null
        /**
         * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         */
        public var sqlInjectionMatchTuples: List<SqlInjectionMatchTuple>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSet) : this() {
            this.name = x.name
            this.sqlInjectionMatchSetId = x.sqlInjectionMatchSetId
            this.sqlInjectionMatchTuples = x.sqlInjectionMatchTuples
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSet = SqlInjectionMatchSet(this)

        internal fun correctErrors(): Builder {
            if (sqlInjectionMatchSetId == null) sqlInjectionMatchSetId = ""
            if (sqlInjectionMatchTuples == null) sqlInjectionMatchTuples = emptyList()
            return this
        }
    }
}
